const mix = require('laravel-mix');
const CleanWebpackPlugin = require('clean-webpack-plugin');

mix.autoload({
  jquery: ['$', 'window.jQuery'],
  jquery: ['jQuery', 'window.jQuery']
});
mix.webpackConfig({
  plugins: [new CleanWebpackPlugin(['./public/js/*.js', './public/css/*.css'])]
});
mix
  .js(
    [
      'resources/assets/js/app.js',
      'node_modules/gasparesganga-jquery-loading-overlay/src/loadingoverlay.js',
      'node_modules/admin-lte/plugins/select2/select2.js',
      'node_modules/equalheight.js/jquery.equal-height.js'
    ],
    'public/js/app.js'
  )
  .version()
  .styles(
    [
      'resources/assets/css/font-awesome.min.css',
      'node_modules/admin-lte/plugins/select2/select2.css'
    ],
    'public/css/vendor.css'
  )
  .sass('resources/assets/sass/app.scss', 'public/css')
  .version()
  .copyDirectory('resources/assets/images', 'public/images');
// Admin
mix
  .js(
    [
      'node_modules/admin-lte/plugins/jQuery/jquery-2.2.3.min.js',
      'node_modules/admin-lte/plugins/iCheck/icheck.min.js',
      'node_modules/admin-lte/plugins/datepicker/bootstrap-datepicker.js',
      'node_modules/admin-lte/plugins/select2/select2.js',
      'node_modules/admin-lte/bootstrap/js/bootstrap.min.js',
      'node_modules/admin-lte/dist/js/app.min.js',
      'node_modules/tinymce/tinymce.min.js',
      'node_modules/gasparesganga-jquery-loading-overlay/src/loadingoverlay.js',
      'resources/assets/js/admin.js'
    ],
    'public/js/admin.js'
  )
  .version()
  .autoload({
    jquery: ['$', 'window.jQuery', 'jQuery']
  })
  .styles(
    [
      'resources/assets/css/font-awesome.min.css',
      'node_modules/admin-lte/bootstrap/css/bootstrap.min.css',
      'node_modules/admin-lte/plugins/select2/select2.css',
      'node_modules/admin-lte/plugins/datepicker/datepicker3.css',
      'node_modules/admin-lte/dist/css/AdminLTE.min.css',
      'node_modules/admin-lte/dist/css/skins/_all-skins.min.css',
      'node_modules/admin-lte/plugins/iCheck/square/blue.css'
    ],
    'public/css/admin.css'
  )
  .version()
  .sass('resources/assets/sass/admin.scss', 'public/css/admin.custom.css')
  .version()
  .copyDirectory('node_modules/tinymce/themes', 'public/js/themes')
  .copyDirectory('node_modules/tinymce/skins', 'public/js/skins')
  .copyDirectory(
    'node_modules/tinymce/plugins/lists',
    'public/js/plugins/lists'
  )
  .copyDirectory(
    'node_modules/tinymce/plugins/image',
    'public/js/plugins/image'
  )
  .copyDirectory('node_modules/tinymce/plugins/link', 'public/js/plugins/link');
