<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Auth::routes();

// Login Routes...
Route::get('login', ['as' => 'login', 'uses' => 'Auth\LoginController@showLoginForm']);
Route::post('login', ['as' => 'login.post', 'uses' => 'Auth\LoginController@login']);
Route::get('logout', ['as' => 'logout', 'uses' => 'Auth\LoginController@logout']);
Route::post('logout', ['as' => 'logout', 'uses' => 'Auth\LoginController@logout']);

// Registration Routes...
Route::get('register', ['as' => 'register', 'uses' => 'Auth\RegisterController@showRegistrationForm']);
Route::post('register', ['as' => 'register.post', 'uses' => 'Auth\RegisterController@register']);

// Password Reset Routes...
Route::get('password/reset', ['as' => 'password.request', 'uses' => 'Auth\ForgotPasswordController@showLinkRequestForm']);
Route::get('password/reset/{token}', ['as' => 'password.reset', 'uses' => 'Auth\ResetPasswordController@showResetForm']);
Route::post('password/email', ['as' => 'password.email', 'uses' => 'Auth\ForgotPasswordController@sendResetLinkEmail']);
Route::post('password/reset', ['as' => 'password.reset.post', 'uses' => 'Auth\ResetPasswordController@reset']);

Route::get('/', 'Frontend\HomeController@index')->name('home');
Route::get('/categories/{category}/select', 'Frontend\HomeController@categoriesSelect')->name('home.categories.select');
Route::get('/categories/autocomplete', 'Frontend\HomeController@categoriesAutocomplete')->name('home.categories.autocomplete');
Route::get('/devenir_exposant', 'Frontend\HomeController@exposant')->name('exposant');
Route::get('/devenir_exposant/confirmation', 'Frontend\HomeController@exposantConfirm')->name('exposant.confirm');
Route::post('/devenir_exposant', 'Frontend\HomeController@exposantStore')->name('exposant.send');

// Demandes
Route::get('demandes/products/{product}', 'Frontend\HomeController@demandeProduits')->name('demandes.produits.index');
Route::post('demandes/products/{product}', 'Frontend\HomeController@demandeProduitsSend')->name('demandes.produits.send');

Route::get('demandes/catalogues/{catalogue}', 'Frontend\HomeController@demandeCatalogues')->name('demandes.catalogues.index');
Route::post('demandes/catalogues/{catalogue}', 'Frontend\HomeController@demandeCataloguesSend')->name('demandes.catalogues.send');


Route::get('category/{category}', 'Frontend\CategoryController@show')->name('categories.show');
Route::get('produits/{category}', 'Frontend\CategoryController@produits')->name('categories.produits');
// Voir les produits d'une company
Route::get('company/{company}', 'Frontend\CompanyController@show')->name('companies.show');
Route::get('company/{company}/places', 'Frontend\CompanyController@places')->name('companies.places');
Route::get('company/{company}/produits', 'Frontend\CompanyController@index')->name('companies.products.index');
Route::get('company/{company}/produits/{product}', 'Frontend\CompanyController@productShow')->name('companies.products.show');
// Voir les produits d'une marque
Route::get('brands/{brand}/produits', 'Frontend\BrandController@index')->name('brands.products.index');
Route::get('brands/{brand}/produits/{product}', 'Frontend\BrandController@productShow')->name('brands.products.show');


Route::get('company/{company}/trends', 'Frontend\CompanyController@trends')->name('companies.trends.index');
Route::get('company/{company}/projects', 'Frontend\CompanyController@projects')->name('companies.projects.index');
//Route::get('company/{company}/catalogues', 'Frontend\CompanyController@catalogues')->name('companies.catalogues.index');
Route::get('company/{company}/salons', 'Frontend\CompanyController@salons')->name('companies.salons.index');


// Trends
Route::get('trends', 'Frontend\TrendController@index')->name('trends.index');
Route::get('trends/{trend}/position', 'Frontend\TrendController@position')->name('trends.position');
Route::get('trends/category/{category}/{trend}', 'Frontend\TrendController@show')->name('trends.show');
Route::get('trends/category/{category}', 'Frontend\TrendController@category')->name('trends.category');

//Projects
Route::get('projects', 'Frontend\ProjectController@index')->name('projects.index');
Route::get('projects/{project}/position', 'Frontend\ProjectController@position')->name('projects.position');
Route::get('projects/category/{category}/{project}', 'Frontend\ProjectController@show')->name('projects.show');
Route::get('projects/category/{category}', 'Frontend\ProjectController@category')->name('projects.category');

//Brands
Route::get('brand/{brand}/catalogues', 'Frontend\BrandController@catalogues')->name('brands.catalogues.index');

//Catalogues
Route::get('catalogues/{category?}', 'Frontend\CatalogueController@index')->name('catalogues.index');
Route::get('brand/{brand}/catalogues/{catalogue}', 'Frontend\CatalogueController@show')->name('catalogues.show');

// Backend Routes
Route::group(['namespace' => 'Backend', 'prefix' => 'admin', 'middleware' => ['auth', 'role:1,3'], 'as' => 'backend.'], function () {
    Route::get('/', 'HomeController@index')->name('index');

    Route::middleware(['role:1'])->group(function () {
        Route::get('categories', 'CategoryController@index')->name('categories.index');
        Route::get('categories/add/{category}', 'CategoryController@addExisting')->name('categories.addexisting');
        Route::post('categories/add/{category}', 'CategoryController@addExistingPost')->name('categories.addexisting.store');
        Route::get('categories/{category}', 'CategoryController@subCategories')->name('categories.sub');
        Route::get('categories/{category}/item', 'CategoryController@item')->name('categories.item');
        Route::get('categories/{category}/edit', 'CategoryController@edit')->name('categories.edit');
        Route::post('categories', 'CategoryController@store')->name('categories.store');
        Route::post('categories/{category}/edit', 'CategoryController@update')->name('categories.update');
        Route::get('categories/{category}/delete', 'CategoryController@delete')->name('categories.delete');
        Route::get('categories/{category}/image', 'CategoryController@image')->name('categories.image');
        Route::post('categories/{category}/image', 'CategoryController@imageStore')->name('categories.image.store');
        //Inscriptions
        Route::get('inscriptions', 'InscriptionController@index')->name('inscriptions.index');
        Route::get('inscriptions/{inscription}/delete', 'InscriptionController@delete')->name('inscriptions.delete');
        Route::get('inscriptions/{inscription}/confirm', 'InscriptionController@createCompany')->name('inscriptions.confirm');
        //Sliders
        Route::get('sliders', 'SliderController@index')->name('sliders.index');
        Route::get('sliders/create', 'SliderController@create')->name('sliders.create');
        Route::post('sliders/create', 'SliderController@store')->name('sliders.store');
        Route::get('sliders/{slider}/edit', 'SliderController@edit')->name('sliders.edit');
        Route::post('sliders/{slider}/edit', 'SliderController@update')->name('sliders.update');
        Route::get('sliders/{slider}/delete', 'SliderController@delete')->name('sliders.delete');

        Route::get('salons/{salon}/companies', 'SalonController@CompanyCreate')->name('salons.companies.create');
        Route::post('salons/{salon}/companies', 'SalonController@CompanyStore')->name('salons.companies.store');
        Route::get('salons/{salon}/companies/{company}', 'SalonController@CompanyDelete')->name('salons.companies.delete');
        Route::get('salons/{salon}/delete', 'SalonController@delete')->name('salons.delete');
        Route::resource('salons', 'SalonController', ['except' => ['destroy']]);

        Route::get('projects/{project}/delete', 'ProjectController@delete')->name('projects.delete');
        Route::resource('projects', 'ProjectController', ['except' => ['destroy']]);

        Route::get('secteur_activites/{activite}/delete', 'SecteurActiviteController@delete')->name('secteur_activites.delete');
        Route::resource('secteur_activites', 'SecteurActiviteController', ['except' => ['destroy']]);

        Route::get('nature_activites/{activite}/delete', 'NatureActiviteController@delete')->name('nature_activites.delete');
        Route::resource('nature_activites', 'NatureActiviteController', ['except' => ['destroy']]);

        //Route::get('catalogues/{catalogue}/delete', 'CatalogueController@delete')->name('catalogues.delete');
        //Route::resource('catalogues', 'CatalogueController', ['except' => ['destroy']]);

        Route::get('trends/{trend}/delete', 'TrendController@delete')->name('trends.delete');
        Route::resource('trends', 'TrendController', ['except' => ['destroy']]);

        Route::get('places/{place}/delete', 'PlaceController@delete')->name('places.delete');
        Route::resource('places', 'PlaceController', ['except' => ['destroy']]);

        Route::get('users/{user}/delete', 'UserController@delete')->name('users.delete');
        Route::resource('users', 'UserController', ['except' => ['destroy']]);
    });



    Route::get('companies/{company}/users/create', 'CompanyController@createUser')->name('companies.users.create');
    Route::post('companies/{company}/users/create', 'CompanyController@storeUser')->name('companies.users.store');
    Route::get('companies/{company}/users/{user}', 'CompanyController@showUser')->name('companies.users.show');
    Route::get('companies/{company}/users/{user}/edit', 'CompanyController@editUser')->name('companies.users.edit');
    Route::post('companies/{company}/users/{user}/edit', 'CompanyController@updateUser')->name('companies.users.update');
    Route::get('companies/{company}/users/{user}/delete', 'CompanyController@deleteUser')->name('companies.users.delete');
    // companies.users.categories
    Route::get('companies/{company}/categories', 'CompanyController@categories')->name('companies.categories');
    Route::get('companies/{company}/categories/select', 'CompanyController@categoriesSelect')->name('companies.categories.select');
    Route::get('companies/wilayas/{wilaya}/communes/select', 'CompanyController@communesSelect')->name('companies.communes.select');
    Route::get('companies/{company}/categories/{category}', 'CompanyController@subCategories')->name('companies.categories.sub');
    Route::post('companies/{company}/categories', 'CompanyController@updateCategories')->name('companies.categories.update');
    Route::get('companies/{company}/products', 'CompanyController@products')->name('companies.products.index');
    Route::get('companies/{company}/products/select', 'CompanyController@productsSelect')->name('companies.products.select');
    Route::post('companies/{company}/products', 'CompanyController@productAdd')->name('companies.products.add');
    Route::get('companies/{company}/products/search', 'CompanyController@productSearch')->name('companies.products.search');
    Route::get('companies/{company}/products/{product}/delete', 'CompanyController@productDelete')->name('companies.products.delete');
    Route::get('companies/{company}/delete', 'CompanyController@delete')->name('companies.delete');
    Route::resource('companies', 'CompanyController', ['except' => ['destroy']]);

    Route::get('/configs', 'ConfigController@index')->name('configs.index');
    Route::post('/configs', 'ConfigController@update')->name('configs.update');

    Route::get('products/import', 'ProductController@import')->name('products.import.index');
    Route::post('products/import', 'ProductController@importStore')->name('products.import.store');
    Route::get('/products/import/categories/{category}/select', 'ProductController@categoriesSelect')->name('products.import.categories.select');
    Route::post('products/export', 'ProductController@export')->name('products.import.export');

    Route::get('products/{product}/delete', 'ProductController@delete')->name('products.delete');
    Route::get('products/category/{category}/attributes', 'ProductController@attributes')->name('products.attributes.index');
    Route::resource('products', 'ProductController', ['except' => ['destroy']]);

    Route::get('brands/{brand}/delete', 'BrandController@delete')->name('brands.delete');
    Route::get('brands/{brand}/catalogue/{catalogue}/delete', 'BrandController@CatalogueDelete')->name('brands.catalogues.delete');
    Route::get('brands/{brand}/catalogue/create', 'BrandController@CatalogueCreate')->name('brands.catalogues.create');
    Route::post('brands/{brand}/catalogue/store', 'BrandController@CatalogueStore')->name('brands.catalogues.store');

    Route::get('brands/{brand}/catalogue/{catalogue}/edit', 'BrandController@CatalogueEdit')->name('brands.catalogues.edit');
    Route::post('brands/{brand}/catalogue/{catalogue}/edit', 'BrandController@CatalogueUpdate')->name('brands.catalogues.update');
    Route::get('brands/{brand}/products', 'BrandController@products')->name('brands.products.index');

    Route::resource('brands', 'BrandController', ['except' => ['destroy']]);

    Route::get('attributes/{category?}', 'AttributeController@index')->name('attributes.index');
    Route::get('attributes/{category}/create', 'AttributeController@create')->name('attributes.create');
    Route::post('attributes/{category}/create', 'AttributeController@store')->name('attributes.store');
    Route::get('attributes/{category}/create_sub/{attribute}', 'AttributeController@createSub')->name('attributes.sub.create');
    Route::post('attributes/{category}/create_sub/{attribute}', 'AttributeController@storeSub')->name('attributes.sub.store');
    Route::get('attributes/{attribute}/show', 'AttributeController@show')->name('attributes.show');
    Route::get('attributes/{attribute}/delete', 'AttributeController@delete')->name('attributes.delete');
    Route::get('attributes/{attribute}/edit', 'AttributeController@edit')->name('attributes.edit');
    Route::post('attributes/{attribute}/edit', 'AttributeController@update')->name('attributes.update');
    //Route::resource('attributes', 'AttributeController', ['except' => ['destroy', 'index', 'create', 'store']]);
});


// Clients Routes
Route::group(['namespace' => 'Client', 'prefix' => 'clients/admin', 'middleware' => ['auth', 'role:2'], 'as' => 'clients.'], function () {
    Route::get('/', 'HomeController@index')->name('index');
    Route::get('/configs', 'ConfigController@index')->name('configs.index');
    Route::get('/configs/wilayas/{wilaya}/communes/select', 'ConfigController@communesSelect')->name('configs.communes.select');
    Route::post('/configs', 'ConfigController@update')->name('configs.update');

    Route::get('products/{product}/delete', 'ProductController@delete')->name('products.delete');
    Route::get('products/category/{category}/attributes', 'ProductController@attributes')->name('products.attributes.index');
    Route::resource('products', 'ProductController', ['except' => ['destroy']]);

    Route::get('salons', 'SalonController@index')->name('salons.index');
    Route::get('salons/{salon}', 'SalonController@show')->name('salons.show');
    Route::get('salons/{salon}/participation', 'SalonController@participation')->name('salons.participation');
    Route::get('salons/{salon}/participation/cancel', 'SalonController@participationCancel')->name('salons.participation.cancel');


    Route::get('projects/{project}/delete', 'ProjectController@delete')->name('projects.delete');
    Route::resource('projects', 'ProjectController', ['except' => ['destroy']]);

    Route::get('trends/{trend}/delete', 'TrendController@delete')->name('trends.delete');
    Route::resource('trends', 'TrendController', ['except' => ['destroy']]);

    Route::get('places/{place}/delete', 'PlaceController@delete')->name('places.delete');
    Route::resource('places', 'PlaceController', ['except' => ['destroy']]);
});
