<div id="menu">
    <div class="navbar-fixed-top">
        <nav class="navbar menu-links" role="navigation">
            <div class="container-fluid">
                <a href="{{ route('exposant') }}" class="pull-right">Devenir exposant</a>
            </div>
        </nav>

        <nav class="navbar " role="navigation">
            <div class="container-fluid">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="{{ route('home') }}">Prosourcing.dz</a>
                </div>
                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" >
                    <ul class="nav navbar-nav navbar-left pull-right">
                        <li>
                            <a href="{{ route('home') }}">Produits</a>
                        </li>
                        <li>
                            <a href="{{ route('catalogues.index') }}">Catalogues</a>
                        </li>
                        <li>
                            <a href="{{ route('projects.index') }}">Projets</a>
                        </li>
                        <li>
                            <a href="{{ route('trends.index') }}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">News & Trends <span class="caret"></span></a>
                            <ul class="dropdown-menu">
                                @php
                                    $categories = \App\Models\TrendCategory::all()
                                @endphp
                                <li><a href="{{ route('trends.index') }}">Liste des tendances dans l'industrie</a></li>
                                <li role="separator" class="divider"></li>
                                @foreach($categories as $category)
                                    <li><a href="{{ route('trends.category', $category) }}">{{ $category->name }}</a></li>
                                @endforeach
                            </ul>
                        </li>
                        <li><a href="#">E-MAGAZINE</a></li>
                        @if(!auth()->check())
                            <li>
                                <a href="{{ route('login') }}" class="link-white"><i class="fa fa-sign-in" aria-hidden="true"></i> Se connecter</a>
                            </li>
                        @elseif(auth()->user()->role_id == 2)
                            <li>
                                <a href="{{ route('clients.index') }}" class="dropdown-toggle link-white" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-user-circle" aria-hidden="true"></i> <span class="caret"></span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li>
                                        <a href="{{ route('clients.index') }}">
                                            <i class="fa fa-tachometer" aria-hidden="true"></i> Espace Entreprise
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('companies.show', auth()->user()->company) }}"><i class="fa fa-globe" aria-hidden="true"></i> Page d'accueil Entreprise</a>
                                    </li>
                                    <li>
                                        <a href="{{ route('logout') }}">
                                            <i class="fa fa-sign-out" aria-hidden="true"></i> Se déconnecter
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @else
                            <li>
                                <a href="{{ route('backend.index') }}" class="link-white">
                                    <i class="fa fa-cogs" aria-hidden="true"></i>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('logout') }}" class="link-white">
                                    <i class="fa fa-sign-out" aria-hidden="true"></i> Se déconnecter
                                </a>
                            </li>
                        @endif
                    </ul>
                    <div class="nav navbar-nav">
                        @include('frontend.search.navbar')
                    </div>
                </div>
                <!-- /.navbar-collapse -->
            </div>
            <!-- /.container -->
        </nav>
    </div>
</div>
