<div class="col-xs-12">
    <div class="box">
        <div class="box-header">
            <h3 class="box-title">{{ $table_title }}</h3>

            <div class="box-tools">
                <div class="input-group input-group-sm" style="width: 250px;">
                     @if(strpos($action, 'D') >= 0)
                         <div class="input-group-btn">
                             <a href="{{ route($route . '.create') }}" class="btn btn-sm btn-success"><i class="fa fa-plus"></i> Ajouter</a>
                         </div>
                     @endif
                    <input type="text" name="table_search" class="form-control pull-right" placeholder="Recherche">
                    <div class="input-group-btn">
                        <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.box-header -->
        <div class="box-body table-responsive no-padding">
            <table class="table table-hover">
                <tbody>
                    <tr>
                        <th style="width: 40px;">ID</th>
                        @foreach($fields as $name => $title)
                            <th>{{ $title }}</th>
                        @endforeach
                        @if(isset($action))
                            <th class="text-right" style="width: 200px;">Action</th>
                        @endif
                    </tr>
                    @foreach($items as $item)
                        <tr>
                            <td>{{ $item->id }}</td>
                        @foreach($fields as $name => $title)
                            <td>{{ $item->{$name} }}</td>
                        @endforeach
                        @if(isset($action))
                            <td class="text-right">
                                <div class="btn-group">
                                    @if(strpos($action, 'r') >= 0) <a href="{{ route($route . '.show', $item) }}" class="btn btn-sm btn-primary"><i class="fa fa-eye"></i> Voir</a> @endif
                                    @if(strpos($action, 'u') >= 0) <a href="{{ route($route . '.edit', $item) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit"></i></a> @endif
                                    @if(strpos($action, 'D') >= 0) <a href="{{ route($route . '.delete', $item) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash"></i></a> @endif
                                </div>
                            </td>
                        @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <!-- /.box-body -->
        <div class="box-footer clearfix text-right">
            {{ $items->links() }}
        </div>
    </div>
    <!-- /.box -->
</div>