@extends('layouts.frontend')

@section('content')
    <ol class="breadcrumb">
        <li><a href="{{ route('trends.index') }}">Projet</a></li>
        <li><a href="{{ route('trends.category', $category) }}">{{ $category->name }}</a></li>
        <li class="active">{{ $project->name }}</li>
    </ol>

    <div class="row">
        <div class="col-md-12 ">
            <h1 class="page-header">
                {{ $project->name }}
            </h1>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <img src="http://via.placeholder.com/800x600&text=Trend%20Image" class="img-responsive">
        </div>
        <div class="col-md-8">
            <p>
                <a href="{{ route('companies.trends.index', $project->company) }}">
                    <strong>{{ $project->company->name }}</strong>
                </a>
            </p>
            <p>
                <a href="{{ route('trends.position', $project) }}" data-toggle="modal" data-target="#modal-xlg">
                    <i class="fa fa-map-marker" aria-hidden="true"></i> {{ $project->adresse }}
                </a>
            </p>
            <p>
                {{ $project->description }}
            </p>
            <p class="text-right">
                @if(!empty($project->link))
                    <a href="{{ $project->link }}" target="_blank">Plus d'informations <i class="fa fa-external-link" aria-hidden="true"></i></a>
                @endif
            </p>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12 ">
            <h3 class="page-header">
                Produits associés
            </h3>
        </div>
        @foreach($products_associated as $product)
            <div class="col-md-2 col-sm-4">
                <div class="thumbnail product-thumbnail text-center">
                    <img src="{{ asset('images/no-photo.jpg') }}" class="img-responsive">
                    <p class="product-name">
                        <strong>
                            <a href="{{ route('companies.products.show', [$product->company, $product]) }}">{{ $product->name }}</a>
                        </strong>
                        <br>
                        {{ $product->ref }}
                    </p>
                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <a href="{{ route('companies.products.index', $product->company) }}">
                                <img src="{{ asset('images/logo-placeholder.jpg') }}" style="width: 80px;">
                            </a>
                            <hr class="line">
                        </div>
                        <div class="col-md-12 col-sm-12 text-left">
                            <a href="{{ route('demandes.produits.index', $product) }}" data-toggle="modal" data-target="#modal-lg"><i class="fa fa-envelope-o" aria-hidden="true"></i> Faire une demande</a> <br>
                            <a href="{{ route('companies.products.show', [$product->company, $product]) }}"><i class="fa fa-plus" aria-hidden="true"></i> Plus d'informations</a> <br>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach

    </div>
    <div class="row">
        <div class="col-md-12 ">
            <h3 class="page-header">
                Autres projets associés
            </h3>
        </div>
        @foreach($projects_associated as $project)
            @include('frontend.projects._project')
        @endforeach
    </div>


@endsection