@php
    $filterAttributes = $category->attributes()->with('childs')->where('filtrable', 1)->where('parent_id', null)->get();
@endphp
@if($filterAttributes->count() > 0)
<div class="filter">
    <form class="form-inline" method="GET">
        <div class="row">
            <div class="col-md-12">
              <h3>Affiner votre recherche</h3>
            </div>
            <div class="filter-inputs">
                @foreach($filterAttributes as $item)
                      @if($item->childs->count() > 0 )
                        <div class="col-md-12 has_childs" data-filter_id="{{ $item->id }}">
                      @else
                        <div class="col-md-12">
                      @endif
                      @include('shared.attributes.'. $item->type .'.filter', ['attribute' => $item])
                    </div>
                    {{--
                        interval: attr-interval-id
                        select: attr-multi-id ou attr-id
                        boolean : attr-id
                        long_text: attr-id
                        number: attr-id
                        text: attr-id    
                    --}}
                    @if($item->childs->count() > 0)
                    @php
                        $requestvalue = request("attr-s-" . $item->id)[0];
                    @endphp
                    @foreach ($item->childs as $child)
                        <div class="col-md-12" @if(trim($requestvalue) != $child->parent_value)style="display: none;"@endif data-filter_parent_id="{{ $item->id }}" data-filter_parent_value="{{ $child->parent_value }}">
                            @include('shared.attributes.'. $child->type .'.filter', ['attribute' => $child])
                        </div>
                    @endforeach
                    @endif
                @endforeach
            </div>
            <div class="filter-btn col-md-12">
                <hr>
                @if(!empty($_GET))
                <a href="{{ route('categories.produits', compact('category')) }}" class="btn btn-reset btn-default btn-block">
                    <i class="fa fa-times" aria-hidden="true"></i> Effacer
                </a>
                @endif
                <button type="submit" class="btn btn-filter btn-default btn-block">
                    <i class="fa fa-filter" aria-hidden="true"></i> Filtrer
                </button>
            </div>
        </div>
    </form>
</div>
@endif