{!! Form::open(['route' => ['demandes.produits.send', $product], 'class' => 'form-horizontal']) !!}
<div class="modal-header no-border">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
    </button>
    <h4 class="modal-title">

    </h4>
</div>
<div class="modal-body">
    <div class="row">
        <div class="col-md-6">

            <div class="form-group col-md-12">
                {!! Form::label('email', 'Votre Email', ['class' => 'control-label']) !!}
                {!! Form::email('email', null,  ['class'=>'form-control', 'required'=>'required', 'placeholder'=>'Votre Email']) !!}
            </div>

            <div class="form-group col-md-12">
                {!! Form::label('message', 'Votre Message', ['class' => 'control-label']) !!}
                {!! Form::textarea('message', null,  ['class'=>'form-control', 'required'=>'required', 'placeholder'=>'Votre Message']) !!}
                <div class="help-block">
                    Pour faciliter le traitement de votre demande de devis, vous devez décrire votre projet (obligatoire)
                </div>
            </div>
            <div class="form-group col-md-12">
                <label for="">Souhaitez-vous également ?</label>
                <div class="checkbox">
                    <label>
                        <input type="checkbox" name="tarifs" value=""> Recevoir les tarifs
                    </label>
                </div>
                <div class="checkbox">
                    <label>
                        <input type="checkbox" name="documentation" value=""> Recevoir une documentation
                    </label>
                </div>
                <div class="checkbox">
                    <label>
                        <input type="checkbox" name="phone" value=""> être recontacté par téléphone
                    </label>
                </div>

            </div>
            
        </div>

        <div class="col-md-6">
            <div class="product-thumbnail text-center">
                @include('shared.product-image')
                <p class="product-name">
                    <strong>
                        <a href="{{ route('brands.products.show', [$product->brand, $product]) }}">{{ $product->name }}</a>
                    </strong>
                    <br>
                    {{ $product->ref }}
                </p>
                <div class="row">
                    <div class="col-md-12 col-sm-12">
                        @include('shared.brand-logo', ['brand' => $product->brand, 'width' => '80px;'])
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer no-border">
    <button type="button" class="btn btn-danger" data-dismiss="modal">Annuler</button>
    <button type="submit" class="btn btn-primary">Envoyer</button>
</div>
{!! Form::close() !!}
