@extends('layouts.frontend')

@section('content')
    <ol class="breadcrumb">
        <li><a href="{{ route('home') }}">Produits</a></li>
        <li class="active">{{ $company->name }}</li>
    </ol>

    @include('frontend.companies.menu', ['active' => 'produits'])

    <div class="row">
        <div class="col-md-12">
            <h1 class="page-header">Tous les produits {{ $company->name }}</h1>
        </div>
    </div>
    <div class="row">
        @foreach($company->categories() as $category)
            <div class="col-md-12">
                <h3 class="page-header">{{ $category->name }}</h3>
            </div>
            <div class="col-md-12">
                <div class="row">
                    @foreach($category->products->where('published', 1)->where('company_id', $company->id) as $product)
                        <div class="col-md-2 col-sm-4">
                            <div class="thumbnail product-thumbnail text-center">
                                @include('shared.product-image')
                                <p class="product-name">
                                    <strong>
                                        <a href="{{ route('companies.products.show', [$company, $product]) }}">{{ $product->name }}</a>
                                    </strong>
                                    <br>
                                    {{ $product->ref }}
                                </p>
                                <div class="row">
                                    <div class="col-md-12 col-sm-12 text-left">
                                        <hr class="line">
                                        <a href="{{ route('demandes.produits.index', $product) }}" data-toggle="modal" data-target="#modal-lg"><i class="fa fa-envelope-o" aria-hidden="true"></i> Faire une demande</a> <br>
                                        <a href="{{ route('companies.products.show', [$company, $product]) }}"><i class="fa fa-plus" aria-hidden="true"></i> Plus d'informations</a> <br>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
@endsection