@extends('layouts.frontend')

@section('content')
    @include('frontend.search.catalogues')
    <div class="row">
        <div class="col-md-2">
            <h3 class="page-header">Par thématique</h3>
            <div class="list-group" id="thematiques_catalogues">
                @foreach($categories as $category)
                    <a href="{{ route('catalogues.index', $category->id) }}" class="list-group-item">{{ $category->name }}</a>
                @endforeach
            </div>
        </div>
        <div class="col-md-10" id="catalogues_content">


            <div class="row">
                <div class="col-md-12 ">
                    <h3 class="page-header">
                        Nouveaux catalogues
                    </h3>
                </div>
            </div>
            <div class="row">
                @foreach($last_catalogues as $catalogue)
                    @include('frontend.catalogues._catalogue')
                @endforeach
            </div>

            <div class="row">
                <div class="col-md-12 ">
                    <h3 class="page-header">
                        Catalogues les plus consultés
                    </h3>
                </div>
            </div>
            <div class="row">
                @foreach($most_view_catalogues as $catalogue)
                    @include('frontend.catalogues._catalogue')
                @endforeach
            </div>


        </div>
    </div>


@endsection