@extends('layouts.frontend')

@section('seo_page_title', $product->seo_page_title)
@section('seo_meta_description', $product->seo_meta_description)

@section('content')
    <ol class="breadcrumb">
        <li><a href="{{ route('home') }}">Produits</a></li>
        <li><a href="{{ route('brands.products.index', $brand) }}">{{ $brand->name }}</a></li>
        <li><a href="{{ route('categories.produits', $product->category) }}">{{ $product->category->name  }}</a></li>
        <li class="active">{{ $product->name }}</li>
    </ol>

    @include('frontend.companies.menu', ['active' => 'produits'])


    <div class="row">

            <div class="col-md-10 col-md-offset-1">
                <h1 class="page-header">
                    {{ $product->name }}
                    <small>
                        {{ $product->ref }}
                    </small>
                </h1>
            </div>
            <div class="col-md-10 col-md-offset-1">
                <div class="row">
                    <div class="col-md-8">
                        <div class="col-md-4">
                            @include('shared.product-image')
                        </div>
                        <div class="col-md-8">

                        {{ $product->description }}

                        @if($product->attributes->count() > 0)
                        <hr class="separator">

                        <div class="panel panel-default">
                            <div class="panel-body">
                                @foreach($product->attributes as $item)
                                    @include('shared.attributes.'.$item->attribute->type.'.show', ['value' => $item->value, 'attribute' => $item->attribute])
                                @endforeach
                            </div>
                        </div>
                        @endif
                        </div>
                    </div>
                    <div class="col-md-4">
                        <a href="{{ route('demandes.produits.index', $product) }}" data-toggle="modal" data-target="#modal-lg" class="btn btn-default btn-lg btn-block">
                            <i class="fa fa-calculator pull-left" aria-hidden="true"></i> Tarfis/Devis
                        </a>
                        <a href="{{ route('demandes.produits.index', $product) }}" data-toggle="modal" data-target="#modal-lg" class="btn btn-default btn-lg btn-block">
                            <i class="fa fa-question pull-left" aria-hidden="true"></i> Question
                        </a>
                        <a href="{{ route('demandes.produits.index', $product) }}" data-toggle="modal" data-target="#modal-lg" class="btn btn-default btn-lg btn-block">
                            <i class="fa fa-book pull-left" aria-hidden="true"></i> Documentation
                        </a>
                        {{-- <a href="{{ route('companies.places', $company) }}" data-toggle="modal" data-target="#modal-xlg" class="btn btn-default btn-lg btn-block">
                            <i class="fa fa-map-marker pull-left" aria-hidden="true"></i> Ou Acheter
                        </a>
                        <a href="{{ asset('storage/companies/'.$product->company->id.'/products/'.$product->fiche_technique) }}" target="_blank" class="btn btn-default btn-lg btn-block">
                            <i class="fa fa-file-pdf-o pull-left" aria-hidden="true"></i> Fiche technique
                        </a> --}}

                        {{--<a href="#" class="btn btn-default btn-lg btn-block">
                            <i class="fa fa-star pull-left" aria-hidden="true"></i> Favoris
                        </a>--}}
                    </div>
                </div>
            </div>
    </div>
@endsection