@extends('layouts.client')

@section('content-header')
    <h1>
        News & Trends
        <small>{{ $trends->total() }} trends</small>
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                        {!! Form::open(['route' => ['clients.trends.index'], 'class' => '', 'method' => 'GET']) !!}
                        <div class="input-group input-group-sm" style="width: 450px;">
                            <input type="text" name="q" class="form-control pull-right" placeholder="Recherche..." value="{{ request('q') }}">

                            <div class="input-group-btn">
                                @if(request('q'))
                                    <a href="{{ route('clients.trends.index') }}" class="btn btn-danger"><i class="fa fa-times" aria-hidden="true"></i></a>
                                @endif
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                <a href="{{ route('clients.trends.create') }}" class="btn btn-sm btn-success"><i class="fa fa-plus" aria-hidden="true"></i> Ajouter News/Trend</a>
                            </div>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Titre</th>
                            <th>Categorie</th>
                            <th style="width: 150px;" class="text-right">Action</th>
                        </tr>
                        @foreach($trends as $trend)
                        <tr>
                            <td>{{ $trend->id }}</td>
                            <td>{{ $trend->name }}</td>
                            <td>{{ isset($trend->category)?$trend->category->name:null }}</td>
                            <td class="text-right">
                                <a href="{{ route('clients.trends.show', $trend->id) }}" class="btn btn-sm btn-success"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                <a href="{{ route('clients.trends.edit', $trend->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                <a href="{{ route('clients.trends.delete', $trend->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                        </tbody></table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    {{ $trends->links() }}
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection