@extends('layouts.client')

@section('content-header')
    <h1>
        Salons
        <small>{{ $salons->total() }} salons</small>
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                        {!! Form::open(['route' => ['clients.salons.index'], 'class' => '', 'method' => 'GET']) !!}
                        <div class="input-group input-group-sm" style="width: 450px;">
                            <input type="text" name="q" class="form-control pull-right" placeholder="Recherche..." value="{{ request('q') }}">

                            <div class="input-group-btn">
                                @if(request('q'))
                                    <a href="{{ route('clients.salons.index') }}" class="btn btn-danger"><i class="fa fa-times" aria-hidden="true"></i></a>
                                @endif
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Nom du salon</th>
                            <th>Date Début/Fin</th>
                            <th>Ville/Pays</th>
                            <th>Participation</th>
                            <th style="width: 150px;" class="text-right">Action</th>
                        </tr>
                        @foreach($salons as $salon)
                        <tr>
                            <td>{{ $salon->id }}</td>
                            <td>
                                @if($salon->confirmed) <span class="label label-success">Confirmé</span> @endif
                                {{ $salon->name }}
                            </td>
                            <td>
                                {{ isset($salon->date_start)?$salon->date_start->format('d/m/Y'):null }} - {{ isset($salon->date_end)?$salon->date_end->format('d/m/Y'):null }}
                            </td>
                            <td>
                                {{ $salon->ville }} - {{ isset($salon->country)?$salon->country->name_fr:null }}
                            </td>
                            <td>
                                @if($salon->companies->contains($company_id))
                                    <span class="label label-success">OUI</span>
                                @endif
                            </td>
                            <td class="text-right">
                                <a href="{{ route('clients.salons.show', $salon->id) }}" class="btn btn-sm btn-success"><i class="fa fa-eye" aria-hidden="true"></i></a>    
                            </td>
                        </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    {{ $salons->links() }}
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection