@extends('layouts.client')

@section('content-header')
    <h1>
        Détails de l'adresse
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="box box-primary">
                <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Nom</label>
                            <p class="static-control">
                                {{ $place->name }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="ref" class="col-md-12">Adresse</label>
                            <p class="static-control">
                                {{ $place->adresse }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Ville</label>
                            <p class="static-control">
                                {{ $place->ville }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Pays</label>
                            <p class="static-control">
                                {{ $place->country->name_fr }}
                            </p>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="description">Email</label>
                                    <p class="static-control">
                                        {{ $place->email }}
                                    </p>
                                </div>
                                <div class="clearfix"></div>
                                <div class="col-md-6">
                                    <label for="description">Téléphone</label>
                                    <p class="static-control">
                                        {{ $place->phone }}
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <label for="description">Mobile</label>
                                    <p class="static-control">
                                        {{ $place->mobile }}
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <label for="description">Fax</label>
                                    <p class="static-control">
                                        {{ $place->fax }}
                                    </p>
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-12">

                                <iframe width="100%"
                                        height="300"
                                        frameborder="0"
                                        scrolling="no"
                                        marginheight="0"
                                        marginwidth="0"
                                        src="https://maps.google.com/maps?q={{ $place->lat }},{{ $place->long }}&hl=fr;z=14&amp;output=embed"
                                ></iframe>

                            </div>
                        </div>
                        <div class="form-group">
                            <label for="description">Image</label>
                            <p class="static-control">
                            @if(isset($place->image) && !empty($place->image))
                                <div>
                                    <img src="{{ asset('storage/companies/'.$place->company->id.'/places/'.$place->image) }}" class="" style="max-width: 300px">
                                </div>
                                <br>
                                @endif
                                </p>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <a href="{{ route('clients.places.edit', $place->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i> Modifier</a>
                        <a href="{{ route('clients.places.delete', $place->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i> Supprimer</a>
                    </div>
            </div>
        </div>
    </div>
@endsection