@extends('layouts.backend')

@section('content-header')
    <h1>
        News & Trends
        <small>{{ $trends->total() }} trends</small>
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                        {!! Form::open(['route' => ['backend.trends.index'], 'class' => 'form-inline', 'method' => 'GET']) !!}
                        <div class="input-group" style="width: 450px;">
                            {{ Form::select('company', $companies , null, ['class' => 'form-control select2', 'placeholder' => 'Sélectionnez une entreprise...'])  }}
                        </div>
                        <div class="input-group">

                            <input type="text" name="q" class="form-control pull-right" placeholder="Recherche..." value="{{ request('q') }}" style="width: 300px;">

                            <div class="input-group-btn">
                                @if(request('q') || request('company'))
                                    <a href="{{ route('backend.trends.index') }}" class="btn btn-danger"><i class="fa fa-times" aria-hidden="true"></i></a>
                                @endif
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                <a href="{{ route('backend.trends.create') }}" class="btn btn-success"><i class="fa fa-plus" aria-hidden="true"></i> Ajouter News/Trend</a>
                            </div>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Titre</th>
                            <th>Categorie</th>
                            <th>Entreprise</th>
                            <th style="width: 150px;" class="text-right">Action</th>
                        </tr>
                        @foreach($trends as $trend)
                        <tr>
                            <td>{{ $trend->id }}</td>
                            <td>{{ $trend->name }}</td>
                            <td>{{ isset($trend->category)?$trend->category->name:null }}</td>
                            <td>{{ isset($trend->company)?$trend->company->name:null }}</td>
                            <td class="text-right">
                                <a href="{{ route('backend.trends.show', $trend->id) }}" class="btn btn-sm btn-success"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.trends.edit', $trend->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.trends.delete', $trend->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                        </tbody></table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    {{ $trends->appends(['q' => request('q'), 'company' => request('company')])->links() }}
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection