@extends('layouts.backend')

@section('content-header')
    <h1>
        Détails de salon
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-6">
            <div class="box box-primary">
                <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Nom du salon</label>
                            <p class="static-control">
                                {{ $salon->name }}
                            </p>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label for="ref" class="col-md-12">Date début/fin:</label>
                                <div class="col-md-3">
                                    <p class="static-control">
                                        {{ isset($salon->date_start)?$salon->date_start->format('d/m/Y'):null }} - {{ isset($salon->date_end)?$salon->date_end->format('d/m/Y'):null }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="coordonnees">Coordonnées du salon</label>
                            <p class="static-control">
                                {!! nl2br($salon->coordonnees) !!}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Ville</label>
                            <p class="static-control">
                                {{ $salon->ville }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Pays</label>
                            <p class="static-control">
                                {{ $salon->country->name_fr }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">lien</label>
                            <p class="static-control">
                                @if(!empty($salon->link))
                                    <a href="{{ $salon->link }}" target="_blank">{{ $salon->link }}</a>
                                @endif
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="values">Logo/Image</label>
                            @if(isset($salon->image) && !empty($salon->image))
                                <div>
                                    <img src="{{ asset('storage/companies/'.$salon->company->id.'/salons/'.$salon->image) }}" class="" style="max-width: 300px">
                                </div>
                                <br>
                            @endif
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <a href="{{ route('backend.salons.edit', $salon->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i> Modifier</a>
                        <a href="{{ route('backend.salons.delete', $salon->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i> Supprimer</a>
                    </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="box box-primary">
                
                <div class="box-header">
                    <h3 class="box-title">
                        Les entreprises participantes
                    </h3>

                    <div class="box-tools">
                        <a href="{{ route('backend.salons.companies.create', $salon->id) }}" data-toggle="modal" data-target="#modal" class="btn btn-sm btn-success">
                            <i class="fa fa-plus" aria-hidden="true"></i> Ajouter une entreprise
                        </a>
                    </div>
                </div>
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody>
                            <tr>
                                <th>Entreprise</th>
                                <th style="width: 150px;" class="text-right">Action</th>
                            </tr>
                            @foreach($salon->companies as $company)                                
                                <tr>
                                    <td>
                                        <a href="{{ route('backend.companies.show', $company->id) }}" target="_blank">{{ $company->name }}</a>
                                    </td>
                                    <td class="text-right">
                                        <a href="{{ route('backend.salons.companies.delete', [$salon->id, $company->id]) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="box-body" id="attributs">
                    
                </div>
            </div>
        </div>
    </div>
@endsection