@extends('layouts.backend')

@section('content-header')
    <h1>
        Salons
        <small>{{ $salons->total() }} salons</small>
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                        {!! Form::open(['route' => ['backend.salons.index'], 'class' => 'form-inline', 'method' => 'GET']) !!}
                        <div class="input-group">

                            <input type="text" name="q" class="form-control pull-right" placeholder="Recherche..." value="{{ request('q') }}" style="width: 300px;">

                            <div class="input-group-btn">
                                @if(request('q'))
                                    <a href="{{ route('backend.salons.index') }}" class="btn btn-danger"><i class="fa fa-times" aria-hidden="true"></i></a>
                                @endif
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                <a href="{{ route('backend.salons.create') }}" class="btn btn-success"><i class="fa fa-plus" aria-hidden="true"></i> Ajouter un salon</a>
                            </div>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Nom du salon</th>
                            <th>Date Début/Fin</th>
                            <th>Ville/Pays</th>
                            <th>Participation</th>
                            <th style="width: 150px;" class="text-right">Action</th>
                        </tr>
                        @foreach($salons as $salon)
                        <tr>
                            <td>{{ $salon->id }}</td>
                            <td>
                                @if($salon->confirmed) <span class="label label-success">Confirmé</span> @endif
                                {{ $salon->name }}
                            </td>
                            <td>
                                {{ isset($salon->date_start)?$salon->date_start->format('d/m/Y'):null }} - {{ isset($salon->date_end)?$salon->date_end->format('d/m/Y'):null }}
                            </td>
                            <td>{{ $salon->ville }} - {{ isset($salon->country)?$salon->country->name_fr:null }}</td>
                            <td>
                                {{ $salon->companies->count() }}
                            </td>
                            <td class="text-right">
                                <a href="{{ route('backend.salons.show', $salon->id) }}" class="btn btn-sm btn-success"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.salons.edit', $salon->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.salons.delete', $salon->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    {{ $salons->appends(['q' => request('q')])->links() }}
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection