@extends('layouts.backend')

@section('content-header')
<h1>
    @if($product->published)
    <i class="fa fa-check-square-o fa-lg" style="color:green" aria-hidden="true"></i>
    @else
    <i class="fa fa-ban fa-lg danger" style="color:red" aria-hidden="true"></i>
    @endif
    @if($product->production_nationale)
    <span><img src="{{ asset('images/dz_flag.png') }}" alt="production nationale"></span>
    @endif
    Détails de produit
</h1>
@endsection
@section('content')
<div class="row">
    <div class="col-md-7">
        <div class="box box-primary">
            <!-- form start -->
            <div class="box-body">
                <div class="form-group">
                    <label for="">Marque</label>
                    <p class="static-control">
                        {{ $product->brand->name }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="">Marque</label>
                    <p class="static-control">
                        {{ $product->brand->name }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="exampleInputEmail1">Catégorie du produit</label>
                    <p class="static-control">
                        {{ $product->category->parent->name }} > {{ $product->category->name }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="">Nom du produit</label>
                    <p class="static-control">
                        {{ $product->name }}
                    </p>
                </div>
                <div class="form-group">
                    <div class="row">
                        <label for="ref" class="col-md-12">Référence produit</label>
                        <div class="col-md-3">
                            <p class="static-control">
                                {{ $product->ref }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="ref">Code douanier</label>
                    <p class="static-control">
                        {{ $product->code_douanier }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="description">Description</label>
                    <p class="static-control">
                        {{ $product->description }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="values">Image</label>
                    @if(isset($product->image) && !empty($product->image))
                    <div>
                        <img src="{{ asset('storage/brands/'.$product->brand_id.'/products/'. $product->id . '/' . $product->image) }}"
                            class="" style="max-width: 300px">
                    </div>
                    <br>
                    @endif
                </div>
                <div class="from-group">
                    <label for="values">Fiche technique</label>
                    <p class="static-control">
                        @if(isset($product->fiche_technique) && !empty($product->fiche_technique))
                        <a href="{{ asset('storage/brands/'.$product->brand_id.'/products/'. $product->id . '/' . $product->fiche_technique) }}"
                            target="_blank">
                            {{ $product->fiche_technique }}
                        </a>
                        @endif
                    </p>
                </div>

                <div class="form-group">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="prix_achat_ht">Prix Achat HT</label>
                            <p class="static-control">
                                {{ $product->prix_achat_ht }}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label for="prix_achat_ttc">Prix Achat TTC</label>
                            <p class="static-control">
                                {{ $product->prix_achat_ttc }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="prix_vente_ht">Prix Vente HT</label>
                            <p class="static-control">
                                {{ $product->prix_vente_ht }}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label for="prix_vente_ttc">Prix Vente TTC</label>
                            <p class="static-control">
                                {{ $product->prix_vente_ttc }}
                            </p>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">
                    SEO
                </h3>
            </div>
            <div class="box-body">
                <div class="form-group">
                    <label for="">Titre de la page</label>
                    <p class="static-control">
                        {{ $product->seo_page_title }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="">Meta description</label>
                    <p class="static-control">
                        {{ $product->seo_meta_description }}
                    </p>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-5">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">
                    Attributs
                </h3>
            </div>
            <div class="box-body" id="attributs">
                @foreach($attributes as $item)
                @include('shared.attributes.'.$item->attribute->type.'.show', ['value' => $item->value, 'attribute' =>
                $item->attribute])
                @endforeach
            </div>

        </div>


        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">
                    Les entreprises proposant le produit
                </h3>
            </div>
            <div class="box-body" id="attributs">
                @foreach($product->companies as $company)
                {{ $company->name }} <br>
                @endforeach
            </div>

        </div>
    </div>
    <div class="col-md-12">
        <div class="box box-widget">
            <div class="box-footer text-right">
                <a href="{{ route('backend.products.edit', $product->id) }}" class="btn btn-sm btn-primary"><i
                        class="fa fa-edit" aria-hidden="true"></i> Modifier</a>
                <a href="{{ route('backend.products.delete', $product->id) }}" class="btn btn-sm btn-danger"
                    data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i> Supprimer</a>
            </div>
        </div>
    </div>
</div>
@endsection