@extends('layouts.backend')

@section('content-header')
    <h1>
        Produits
        <small>{{ $products->total() }} produits</small>
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                        {!! Form::open(['route' => ['backend.products.index'], 'class' => 'form-inline', 'method' => 'GET']) !!}
                        <div class="input-group">

                            <input type="text" name="q" class="form-control pull-right" placeholder="Recherche..." value="{{ request('q') }}" style="width: 300px;">

                            <div class="input-group-btn">
                                @if(request('q') || request('company'))
                                    <a href="{{ route('backend.products.index') }}" class="btn btn-danger"><i class="fa fa-times" aria-hidden="true"></i></a>
                                @endif
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                <a href="{{ route('backend.products.create') }}" class="btn btn-success"><i class="fa fa-plus" aria-hidden="true"></i> Ajouter un produit</a>
                            </div>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Ref</th>
                            <th>Nom du produit</th>
                            <th>Categorie</th>
                            <th>Marque</th>
                            <th>Actif</th>
                            <th style="width: 150px;" class="text-right">Action</th>
                        </tr>
                        @foreach($products as $product)
                        <tr>
                            <td>{{ $product->id }}</td>
                            <td>{{ $product->ref }}</td>
                            <td>{{ $product->name }}</td>
                            <td>{{ isset($product->category)?$product->category->name:null }}</td>
                            <td>{{ isset($product->brand)?$product->brand->name:null }}</td>
                            <td>
                                @if($product->published)
                                    <i class="fa fa-check-square-o fa-lg" style="color:green" aria-hidden="true"></i>
                                @else
                                    <i class="fa fa-ban fa-lg danger" style="color:red" aria-hidden="true"></i>
                                @endif
                            </td>
                            <td class="text-right">
                                <a href="{{ route('backend.products.show', $product->id) }}" class="btn btn-sm btn-success"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.products.edit', $product->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.products.delete', $product->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                        </tbody></table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    {{ $products->appends(['q' => request('q'), 'company' => request('company')])->links() }}
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection