@extends('layouts.backend')

@section('content-header')
<h1>
    Creation de produit
</h1>
@endsection
@section('content')
{!! Form::open(['route' => ['backend.products.store'], 'class' => '', 'files' => true]) !!}
<div class="row">
    <div class="col-md-7">
        <div class="box box-primary">
            @include('backend.products._form')
        </div>
        <div class="box box-primary">
            @include('backend.products._seo')
        </div>
    </div>
    <div class="col-md-5">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">
                    Attributs
                </h3>
            </div>
            <div class="box-body" id="attributs">

            </div>

        </div>
    </div>
    <div class="col-md-12">
        <div class="box box-widget">
            <div class="box-footer text-right">
                <a href="{{ URL::previous() }}" class="btn btn-danger">Annuler</a>
                <button type="submit" class="btn btn-primary">Enregistrer</button>
            </div>
        </div>
    </div>
</div>
{!! Form::close() !!}
@endsection

@section('scripts')
<script>
    $(function(){

            {{-- $("#search").keyup(function () {
                var filter = $(this).val();
                $("#categories-list .category-item:not([data-selected='1'])").each(function () {
                    if ($(this).text().search(new RegExp(filter, "i")) < 0) {
                        $(this).hide();
                    } else {
                        $(this).show()
                    }
                });
            });

            $("a.category-item").on('click', function(event){
                event.preventDefault();

                var $idCategory = $(this).data('position');
                var $nameCategory = $(this).data('category');
                console.log($idCategory);
                $(".close-search").click();
                $("#search").val($nameCategory);
                $("#category_id").val($idCategory);
                $('#attributs').load('/admin/products/category/' + $idCategory + '/attributes', function() {});
            });

            $("#search").on('focus', function(event) {
                $('.categories-container').show();
                $(".close-search").show();
            });
            $(".close-search").on('click', function(event) {
                event.preventDefault();
                $("#search").val("");
                $("#search").keyup();

                $('.categories-container').hide();
                $(".close-search").hide();
            }); --}}



            $('body').on('change', '#category_id',function(){
                $('#attributs').load('/admin/products/category/' + $(this).val() + '/attributes', function() {});
            });
        })
</script>
@endsection