<div class="box-body">
    <div class="form-group">
        <label for="name">Marque</label>
        <div class="row">
            <div class="col-md-12">
                {{ Form::select('brand_id',
                    $brands ,
                    null,
                    [
                        'class' => 'form-control select2',
                        'placeholder' => 'Sélectionnez une marque...',
                        'required' => 'required',
                        'id' => 'brand_id'
                    ])
                }}
            </div>
        </div>

    </div>

    <div class="form-group">
        <label for="">Catégories</label>
        <div class="row">
            <span id="categories_container_l0" class="col-md-4">
                {{ Form::select('category_id_l0', $categories_l0, isset($product)?$product->category->parent->parent->id:null, [
                    'class' => 'form-control select2 w100',
                    'placeholder' => 'Séléctionnez une catégorie...',
                    'required' => 'required',
                    'id' => 'category_id_l0'
                ]) }}
            </span>
            <span id="categories_container_l1" class="col-md-4">
                {{ Form::select('category_id_l1', isset($categories_l1)?$categories_l1:[], isset($product)?$product->category->parent->id:null, [
                    'class' => 'form-control select2 w100',
                    'placeholder' => 'Séléctionnez une catégorie...',
                    'required' => 'required',
                    'id' => 'category_id_l1',
                    'disabled' => !isset($product)
                ]) }}
            </span>
            <span id="categories_container_l2" class="col-md-4">
                {{-- <select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select> --}}
                {{ Form::select('category_id', isset($categories_l2)?$categories_l2:[], isset($product)?$product->category->id:null, [
                    'class' => 'form-control select2 w100',
                    'placeholder' => 'Séléctionnez une catégorie...',
                    'required' => 'required',
                    'id' => 'category_id',
                    'disabled' => !isset($product)
                ]) }}
            </span>
        </div>
    </div>

    <div class="form-group">
        <label for="name">Nom du produit</label>
        {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => 'Nom du produit'])  }}
    </div>
    <div class="form-group">
        <label for="name">Production nationale</label>
        {{ Form::select('production_nationale', [
            1 => 'Oui',
            0 => 'Non'
        ] ,null, ['class' => 'form-control'])  }}
    </div>
    <div class="form-group">
        <label for="name">Actif</label>
        {{ Form::select('published', [
            1 => 'Oui',
            0 => 'Non'
        ] ,null, ['class' => 'form-control'])  }}
    </div>
    <div class="form-group">
        <div class="row">
            <label for="ref" class="col-md-12">Référence produit</label>
            <div class="col-md-3">
                {{ Form::text('ref', null, ['class' => 'form-control', 'placeholder' => 'Référence', 'required' => 'required'])  }}
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <label for="code_douanier" class="col-md-12">Code douanier</label>
            <div class="col-md-6">
                {{ Form::text('code_douanier', null, ['class' => 'form-control', 'placeholder' => 'Code douanier'])  }}
            </div>
        </div>
    </div>
    <div class="form-group">
        <label for="description">Description</label>
        {{ Form::textarea('description', null, ['class' => 'form-control', 'placeholder' => 'Description', 'rows'=> 5,  'maxlength' => 500])  }}
        <p class="help-block">500 caractère maximum</p>
    </div>
    <div class="form-group">
        <label for="values">Image</label>
        @if(isset($product->image) && !empty($product->image))
        <div>
            <img src="{{ asset('storage/brands/'.$product->brand->id.'/products/'. $product->id . '/' .$product->image) }}"
                class="" style="max-width: 300px">
        </div>
        <br>
        @endif
        {{ Form::file('image', null, ['class' => 'form-control', 'required' => 'required'])  }}
        @if(isset($product))
        <p class="help-block">Pour modifier l'image selectionneez une autre </p>
        @endif
    </div>
    <div class="form-group">
        <label for="values">Fiche technique</label>
        @if(isset($product->fiche_technique) && !empty($product->fiche_technique))
        <p class="static-control">
            <a href="{{ asset('storage/brands/'.$product->brand->id.'/products/'.$product->fiche_technique) }}"
                target="_blank">
                {{ $product->fiche_technique }}
            </a>
        </p>
        @endif
        {{ Form::file('fiche_technique', null, ['class' => 'form-control', 'required' => 'required'])  }}
        @if(isset($product))
        <p class="help-block">Pour modifier la fiche technique selectionneez une autre </p>
        @endif
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label for="prix_achat_ht">Prix Achat HT</label>
                {{ Form::number('prix_achat_ht', null, ['class' => 'form-control', 'placeholder' => 'Prix Achat HT'])  }}
                <p class="help-block">Infos Tinsal</p>
            </div>
            <div class="col-md-6">
                <label for="prix_achat_ttc">Prix Achat TTC</label>
                {{ Form::number('prix_achat_ttc', null, ['class' => 'form-control', 'placeholder' => 'Prix Achat TTC'])  }}
                <p class="help-block">Infos Tinsal</p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label for="prix_vente_ht">Prix Vente HT</label>
                {{ Form::number('prix_vente_ht', null, ['class' => 'form-control', 'placeholder' => 'Prix Vente HT'])  }}
                <p class="help-block">Infos Tinsal</p>
            </div>
            <div class="col-md-6">
                <label for="prix_vente_ttc">Prix Vente TTC</label>
                {{ Form::number('prix_vente_ttc', null, ['class' => 'form-control', 'placeholder' => 'Prix Vente TTC'])  }}
                <p class="help-block">Infos Tinsal</p>
            </div>
        </div>
    </div>
</div>