@extends('layouts.backend')

@section('content-header')
    <h1>
        Inscriptions
        <small>{{ $inscriptions->total() }} inscriptions</small>
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                        {!! Form::open(['route' => ['backend.inscriptions.index'], 'class' => 'form-inline', 'method' => 'GET']) !!}
                        <div class="input-group">

                            <input type="text" name="q" class="form-control pull-right" placeholder="Recherche..." value="{{ request('q') }}" style="width: 300px;">

                            <div class="input-group-btn">
                                @if(request('q') || request('company'))
                                    <a href="{{ route('backend.inscriptions.index') }}" class="btn btn-danger"><i class="fa fa-times" aria-hidden="true"></i></a>
                                @endif
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Entreprise</th>
                            <th>Catégorie</th>
                            <th>Contact</th>
                            <th>Adresse</th>
                            <th style="width: 250px;" class="text-right">Action</th>
                        </tr>
                        @foreach($inscriptions as $inscription)
                        <tr>
                            <td>{{ $inscription->id }}</td>
                            <td>
                                {{ $inscription->company_name }} <br>
                                <a href="{{ $inscription->company_site }}" target="_blank">{{ $inscription->company_site }} </a>
                            </td>
                            <td>{{ $inscription->category->name }}</td>
                            <td>
                                {{ $inscription->prenom }} {{ $inscription->nom }} <br>
                                {{ $inscription->email }} <br>
                                {{ $inscription->phone }} <br>
                                {{ $inscription->country->name_fr }}
                                
                            </td>
                            <td>{{ $inscription->adresse }}</td>
                            <td class="text-right">
                                <a href="{{ route('backend.inscriptions.confirm', $inscription->id) }}" class="btn btn-sm btn-success" data-confirm="confim" data-message="Etes-vous sûr de vouloir valider cette inscription?">Valider et créer le compte</a>
                                <a href="{{ route('backend.inscriptions.delete', $inscription->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                        </tbody></table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    {{ $inscriptions->appends(['q' => request('q')])->links() }}
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection