@extends('layouts.backend')

@section('content-header')
    <h1>
        Entreprises
        <small>{{ $companies->total() }} entreprises</small>
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                        {!! Form::open(['route' => ['backend.companies.index'], 'class' => 'form-inline', 'method' => 'GET']) !!}
                        <div class="input-group">

                            <input type="text" name="q" class="form-control pull-right" placeholder="Recherche..." value="{{ request('q') }}" style="width: 300px;">

                            <div class="input-group-btn">
                                @if(request('q') || request('company'))
                                    <a href="{{ route('backend.companies.index') }}" class="btn btn-danger"><i class="fa fa-times" aria-hidden="true"></i></a>
                                @endif
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                <a href="{{ route('backend.companies.create') }}" class="btn btn-success"><i class="fa fa-plus" aria-hidden="true"></i> Ajouter une entreprise</a>
                            </div>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Nom de l'entreprise</th>
                            <th>Email</th>
                            <th>Tél/Fax</th>
                            <th>Actif</th>
                            <th style="width: 200px;" class="text-right">Action</th>
                        </tr>
                        @foreach($companies as $company)
                        <tr>
                            <td>{{ $company->id }}</td>
                            <td>{{ $company->name }}</td>
                            <td>{{ $company->email }}</td>
                            <td>{{ $company->phone }} / {{ $company->fax }}</td>
                            <td>
                                @if($company->published)
                                    <i class="fa fa-check-square-o fa-lg" style="color:green" aria-hidden="true"></i>
                                @else
                                    <i class="fa fa-ban fa-lg danger" style="color:red" aria-hidden="true"></i>
                                @endif
                            </td>
                            <td class="text-right">
                                <a href="{{ route('backend.companies.products.index', $company->id) }}" class="btn btn-sm btn-default"><i class="fa fa-cubes" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.companies.show', $company->id) }}" class="btn btn-sm btn-success"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.companies.edit', $company->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.companies.delete', $company->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                        </tbody></table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    {{ $companies->appends(['q' => request('q')])->links() }}
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection