{!! Form::open(['route' => ['backend.companies.categories.update', $company->id], 'class' => 'form-horizontal', 'method' => 'POST']) !!}
<div class="modal-header no-border">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
    </button>
    <h4 class="modal-title">
        Modifier les Catégories
    </h4>
</div>
<div class="modal-body">
    <div class="row">

    <div class="col-md-6">
        <div class="">
            <input type="text" name="search" id="search" placeholder="Recherche" class="form-control">
        </div>
        <div class="" style="height: 500px;overflow: auto;border:1px solid #CCCCCC;padding: 10px;">
            <div class="list-group" id="categories-list">
                @foreach($categories as $category)
                    <div class="category-item" id="cat-{{ $category->id }}" data-position="{{ $category->id }}">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="categories[]" value="{{ $category->id }}">
                                {{ $category->parent->name }} > {{ $category->name }}
                                <br>
                                <small>
                                    <strong>{{ $category->parent->parent->name }}</strong>
                                </small>
                            </label>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="">
            <div class="" style="height: 535px;overflow: auto;border:1px solid #CCCCCC;padding: 10px;">
                <div class="list-group" id="categories-list-selected">

                    @foreach($selected_categories as $category)
                        <div class="category-item" id="cat-{{ $category->id }}" data-position="{{ $category->id }}">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="categories[]" value="{{ $category->id }}" checked>
                                    {{ $category->parent->name }} > {{ $category->name }}
                                    <br>
                                    <small>
                                        <strong>{{ $category->parent->parent->name }}</strong>
                                    </small>
                                </label>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    </div>
</div>

<div class="modal-footer no-border">
    <button type="button" class="btn btn-danger pull-left" data-dismiss="modal">Annuler</button>
    <button type="submit" class="btn btn-success">Enregistrer</button>
</div>
{!! Form::close() !!}

<style>
    .indent {
        padding-left: 15px;
    }
    .category-item {
        padding-bottom: 10px;
    }
</style>
<script>
    $(function(){
        $('.select2').select2();
        /*$('#categories').on('change', function(event){
            console.log($(this).val());
            $selected = $(this).val();

            $('#categories-list').load( $('#categories-list').data('href') + '/' + $selected, function( response, status, xhr ){

            });
        });*/
        $('body').on('change', "#categories-list .category-item input[type='checkbox']", function(event){
            event.preventDefault();
            $(this).parents('.category-item').prependTo("#categories-list-selected");
            //$("#categories-list-selected input[name='allcats[]']").attr('name', 'categories[]');
            var divList = null;
            divList = $('#categories-list-selected .category-item');
            divList.sort(function(a, b){
                return $(a).data("position")-$(b).data("position")
            });
            $('#categories-list-selected').html(divList);
        });

        $('body').on('change', "#categories-list-selected .category-item input[type='checkbox']", function(event){
            event.preventDefault();
            $(this).parents('.category-item').prependTo("#categories-list");
            //$("#categories-list input[name='categories[]']").attr('name', 'allcats[]');
            var divList = null;
            divList = $('#categories-list .category-item');
            divList.sort(function(a, b){
                return $(a).data("position")-$(b).data("position")
            });
            $('#categories-list').html(divList);
        });

        $("#search").keyup(function () {
            var filter = $(this).val();
            $("#categories-list .category-item:not([data-selected='1'])").each(function () {
                if ($(this).text().search(new RegExp(filter, "i")) < 0) {
                    $(this).hide();
                } else {
                    $(this).show()
                }
            });
        });
    });
</script>