@foreach($categories as $item)
<div class="list-group-item" id="cat-{{ $item->id }}"
    data-href-item="{{ route('backend.categories.item', $item->id) }}">
    @include('backend.categories.item', ['category' => $item])
</div>
@endforeach
<div class="list-group-item list-group-item-create" style="display: none;">
    <div class="cat-form input-group input-group-sm list-group-item-edit">
        <input type="text" class="form-control" name="name" value=""
            data-href="{{ route('backend.categories.store') }}">
        <input type="hidden" name="parent_id" value="{{ $category_selected->id }}">
        <input type="hidden" name="level" value="{{ $category_selected->level+1 }}">
        <span class="input-group-btn">
            <a class="btn btn-save-new btn-success" href="#">
                <i class="fa fa-check" aria-hidden="true"></i>
            </a>
            <a class="btn btn-cancel-new btn-default" href="#">
                <i class="fa fa-ban" aria-hidden="true"></i>
            </a>
        </span>
    </div>
</div>
@if($category_selected->level == 1)
<div class="btn-group btn-add-container btn-group-justified" role="group" aria-label="">
    <div class="btn-group btn-add-container" role="group">
        <a href="#" class="btn btn-success btn-add"><i class="fa fa-plus" aria-hidden="true"></i>
            Nouvelle catégorie</a>
        <a href="{{ route('backend.categories.addexisting', $category_selected->id) }}" data-toggle="modal"
            data-target="#modal-lg" class="btn btn-primary pull-right">
            <i class="fa fa-plus" aria-hidden="true"></i> Catégorie existante
        </a>
    </div>
</div>
@endif