<div class="list-group-item-view">
    @include('backend.categories/item-image', ['category' => $category])
    <div class="category_name">
        {{ $category->name }}
    </div>
    <div class="btn-group pull-right btn-group-sm" role="group">

        @if(empty($category->copy_id))
        <a href="#" data-href="{{ route('backend.categories.edit', $category->id) }}" class="btn-edit btn btn-primary">
            <i class="fa fa-edit" aria-hidden="true"></i>
        </a>
        @endif
        <a href="{{ route('backend.categories.delete', $category->id) }}" data-confirm="delete" data-remote="true"
            class="btn-delete btn btn-danger"
            data-message="Etes-vous sûr de vouloir supprimer la catégorie et les produits associés">
            <i class="fa fa-trash" aria-hidden="true"></i>
        </a>
        @if($category->level != 2)
        <a href="#" data-href="{{ route('backend.categories.sub', $category->id) }}" data-id="{{ $category->id }}"
            class="btn btn-sub btn-default">
            <i class="fa fa-chevron-right" aria-hidden="true"></i>
        </a>
        @endif
    </div>
</div>
<div class="cat-form input-group input-group-sm list-group-item-edit" style="display: none;">
    <input type="text" class="form-control" value="{{ $category->name }}" data-id="{{ $category->id }}"
        data-href="{{ route('backend.categories.update', $category->id) }}">
    <span class="input-group-btn">
        <a class="btn btn-save btn-success" href="#">
            <i class="fa fa-check" aria-hidden="true"></i>
        </a>
        <a class="btn btn-cancel btn-default" href="#">
            <i class="fa fa-ban" aria-hidden="true"></i>
        </a>
    </span>
</div>