@extends('layouts.backend')

@section('content-header')
<h1>
    Catégories
</h1>
@endsection
@section('content')
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">

                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body no-padding">
                <div class="col-md-4 categories-container">
                    <div class="list-group" id="categories-0" data-href="{{ route('backend.categories.sub', 0) }}">
                        @foreach($categories as $category)
                        <div class="list-group-item" id="cat-{{ $category->id }}"
                            data-href-item="{{ route('backend.categories.item', $category->id) }}">
                            @include('backend.categories.item')
                        </div>
                        @endforeach
                        <div class="list-group-item list-group-item-create" style="display: none;">
                            <div class="cat-form input-group input-group-sm list-group-item-edit">
                                <input type="text" class="form-control" name="name" value=""
                                    data-href="{{ route('backend.categories.store') }}">
                                <input type="hidden" name="parent_id" value="0">
                                <input type="hidden" name="level" value="0">
                                <span class="input-group-btn">
                                    <a class="btn btn-save-new btn-success" href="#">
                                        <i class="fa fa-check" aria-hidden="true"></i>
                                    </a>
                                    <a class="btn btn-cancel-new btn-default" href="#">
                                        <i class="fa fa-ban" aria-hidden="true"></i>
                                    </a>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="btn-group btn-add-container btn-group-justified" role="group" aria-label="">
                        <div class="btn-group btn-add-container" role="group">
                            <a href="#" class="btn btn-success btn-add"><i class="fa fa-plus" aria-hidden="true"></i>
                                Ajouter</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 categories-container">
                    <div class="list-group" id="categories-1">

                    </div>
                    <div class="btn-group btn-add-container btn-group-justified" role="group" aria-label=""
                        style="display: none;">
                        <div class="btn-group btn-add-container" role="group">
                            <a href="#" class="btn btn-success btn-add"><i class="fa fa-plus" aria-hidden="true"></i>
                                Ajouter</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 categories-container">
                    <div class="list-group" id="categories-2">

                    </div>
                    {{-- <div class="btn-group btn-add-container btn-group-justified" role="group" aria-label=""
                        style="display: none;">
                        <div class="btn-group btn-add-container" role="group">
                            <a href="#" class="btn btn-success btn-add"><i class="fa fa-plus" aria-hidden="true"></i>
                                Nouvelle catégorie</a>

                            <a href="{{ route('backend.categories.addexisting', 1) }}" data-toggle="modal"
                    data-target="#modal" class="btn btn-primary pull-right">
                    <i class="fa fa-plus" aria-hidden="true"></i> Catégorie existante
                    </a>

                </div>

            </div> --}}
        </div>
    </div>
    <!-- /.box-body -->
    <div class="box-footer clearfix">
    </div>
</div>
<!-- /.box -->
</div>
</div>
@endsection

<style>
    .categories-container .list-group-item {
        min-height: 50px;
    }

    .categories-container * {
        -webkit-border-radius: 0px;
        -moz-border-radius: 0px;
        border-radius: 0px !important;
    }

    .btn-add-container .btn {
        width: 50% !important;
    }
</style>

@section('scripts')
<script>
    $(function(){
            $('body').on('click', '#categories-0 a.btn-sub', function(event){
                event.preventDefault();
                $('#categories-0 .bg-gray').removeClass('bg-gray');
                $(this).parents('.list-group-item').addClass('bg-gray');
                //Afficher le 2 bouttons Edit/Delet
                $(this).parents('.categories-container').find('.btn-edit-container').show();
                $(this).parents('.categories-container').find('.btn-delete-container').show();

                //$('#categories-1').LoadingOverlay("show");
                $('#categories-2').html('');
                $('#categories-2').parents('.categories-container').find('.btn-add-container').hide();
                $('#categories-1').load($(this).data('href'), function( response, status, xhr ){
                    $('#categories-1').parents('.categories-container').find('.btn-add-container').show();
                });
            });
            $('body').on('click', '#categories-1 a.btn-sub' ,function(event){
                event.preventDefault();
                $('#categories-1 .bg-gray').removeClass('bg-gray');
                $(this).parents('.list-group-item').addClass('bg-gray');
                //$('#categories-1').LoadingOverlay("show");
                $('#categories-2').load($(this).data('href'), function( response, status, xhr ){
                    $('#categories-2').parents('.categories-container').find('.btn-add-container').show();
                });
            });
            //

            $('body').on('click', '.btn-edit', function(event){
                event.preventDefault();
                $('.list-group-item-view:hidden').show();
                $('.list-group-item-edit:visible').hide();
                $(this).parents('.list-group-item').find('.list-group-item-view').hide();
                $(this).parents('.list-group-item').find('.list-group-item-edit').show();
            });

            $('body').on('click', '.btn-cancel', function(event){
                event.preventDefault();
                $(this).parents('.list-group-item').find('.list-group-item-view').show();
                $(this).parents('.list-group-item').find('.list-group-item-edit').hide();
            });

            $('body').on('click', '.btn-cancel-new', function(event){
                event.preventDefault();
                $(this).parents('.categories-container').find('.list-group-item-create').hide();
            });

            $('body').on('click', '.btn-add', function(event){
                event.preventDefault();
                $(this).parents('.categories-container').find('.list-group-item-create').show();
            });

            $('body').on('click', '.btn-save-new', function(event){
                event.preventDefault();
                $formdiv = $(this).parents('.cat-form');
                $input = $formdiv.find("input[name='name']");
                //$formdiv.("input[name='name']").val()
                var datastring = $formdiv.find('input').serialize();
                console.log(datastring);

                $formdiv.LoadingOverlay("show");
                $.ajax({
                    type: "POST",
                    url: $input.data('href'),
                    data: datastring,
                    dataType: "html",
                    success: function(data) {
                        $formdiv.LoadingOverlay("hide");
                        $input.parents('.categories-container').find('.list-group-item-create').before(data);
                        $input.parents('.categories-container').find('.list-group-item-create').hide();
                    },
                    error: function() {
                        $formdiv.LoadingOverlay("hide");
                    }
                });

            });

            $('body').on('click', '.btn-save', function(event){
                event.preventDefault();
                $formdiv = $(this).parents('.cat-form');
                $input = $formdiv.find('input');
                $parent = $input.parents('.list-group-item');

                $formdiv.LoadingOverlay("show");
                $.ajax({
                    type: "POST",
                    url: $input.data('href'),
                    data: { name: $input.val() },
                    dataType: "json",
                    success: function(data) {
                        $formdiv.LoadingOverlay("hide");

                        $parent.load($parent.data('href-item'), function(response, status, xhr) {
                            $parent.LoadingOverlay("hide");
                        });

                        $parent.find('.list-group-item-view').show();
                        $parent.find('.list-group-item-edit').hide();

                    },
                    error: function() {
                        $formdiv.LoadingOverlay("hide");
                        $parent.find('.list-group-item-view').show();
                        $parent.find('.list-group-item-edit').hide();
                    }
                });

            });

            $('body').on('click', '.deleteRemote', function(ev) {
                ev.preventDefault();
                var href = $(this).attr('href');
                var parent = $('.box-body');

                //$(this).parents('.list-group-item').LoadingOverlay("show");
                $.getJSON(href, function(data) {

                }).done(function(data) {
                    $('#dataConfirmModal').modal('hide');
                    //$.notify({ message: data.message }, { type: data.type });
                    //$('#cat-' + data.id).LoadingOverlay("hide");
                    var $level = $('#cat-' + data.id).parents('.list-group').attr('id').replace('categories-', '');
                    if($level == '0') {
                        $('#categories-1').html('');
                        $('#categories-1').parents('.categories-container').find('.btn-add-container').hide();
                        $('#categories-2').html('');
                        $('#categories-2').parents('.categories-container').find('.btn-add-container').hide();
                    }else if($level == '1') {
                        $('#categories-2').html('');
                        $('#categories-2').parents('.categories-container').find('.btn-add-container').hide();
                    }
                    $('#cat-' + data.id).remove();
                });
            });
            $('body').on('submit','#form-exist-cat' ,function(event) {
                    event.preventDefault();
                    $href = $(this).attr('action');
                    $idcategory = $(this).find('#category_id').val();
                    console.log($(this).find('#category_id').val());
                    console.log($(this).attr('action'));
                    // #categories-2 > before list-group-item-create
                    ///
                    ///
                    ///
                    $.ajax({
                        type: "POST",
                        url: $href,
                        data: { id_clone: $idcategory },
                        dataType: "html",
                        success: function(data) {
                            //$formdiv.LoadingOverlay("hide");
                            $('#categories-2').find('.list-group-item-create').before(data);
                            //$input.parents('.categories-container').find('.list-group-item-create').hide();
                            $('#modal-lg').modal('hide');
                        },
                        error: function() {
                            //$formdiv.LoadingOverlay("hide");
                            $('#modal-lg').modal('hide');
                        }
                    });
                    ///
                    ///





                    //
                    
                })
        })
</script>
@endsection