{!! Form::model($category, ['route' => ['backend.categories.addexisting.store', $category->id],
'class' => 'form-horizontal',
'method' => 'POST',
'files' => true,
'id' => 'form-exist-cat']) !!}
<div class="modal-header no-border">
  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
      aria-hidden="true">&times;</span></button>
  <h4 class="modal-title">
    Ajouter de catégorie existante
  </h4>
</div>
<div class="modal-body">
  <div class="col-md-12">
    <div class="form-group">
      <label for="">Catégories</label>
      <div class="row">
        <span id="categories_container_l0" class="col-md-4">
          {{ Form::select('category_id_l0', $categories_l0, isset($product)?$product->category->parent->parent->id:null, [
                        'class' => 'form-control select2 w100',
                        'placeholder' => 'Séléctionnez une catégorie...',
                        'required' => 'required',
                        'id' => 'category_id_l0'
                    ]) }}
        </span>
        <span id="categories_container_l1" class="col-md-4">
          {{ Form::select('category_id_l1', isset($categories_l1)?$categories_l1:[], isset($product)?$product->category->parent->id:null, [
                        'class' => 'form-control select2 w100',
                        'placeholder' => 'Séléctionnez une catégorie...',
                        'required' => 'required',
                        'id' => 'category_id_l1',
                        'disabled' => !isset($product)
                    ]) }}
        </span>
        <span id="categories_container_l2" class="col-md-4">
          {{-- <select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select> --}}
          {{ Form::select('category_id', isset($categories_l2)?$categories_l2:[], isset($product)?$product->category->id:null, [
                        'class' => 'form-control select2 w100',
                        'placeholder' => 'Séléctionnez une catégorie...',
                        'required' => 'required',
                        'id' => 'category_id',
                        'disabled' => !isset($product)
                    ]) }}
        </span>
      </div>
    </div>
  </div>
</div>

<div class="modal-footer no-border">
  <button type="button" class="btn btn-danger pull-left" data-dismiss="modal">Fermer</button>
  <button type="submit" class="btn btn-success">Enregistrer</button>
</div>

<script>
  $('#category_id_l0').on('change', function(){
        var $selected_cat = $(this).val();
        if($selected_cat) {
            $('#categories_container_l1').load('/categories/'+$selected_cat+'/select?level=1', function() {
                $('.select2').select2();
            })
        }else{
            $('#categories_container_l1').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
            $('#categories_container_l2').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
            $('.select2').select2();
        }
    });

    $('#categories_container_l1').on('change', '#category_id_l1', function(){
        var $selected_cat = $(this).val();
        if($selected_cat) {
            $('#categories_container_l2').load('/categories/'+$selected_cat+'/select?level=2', function() {
                $('.select2').select2();
            })
        }else{
            $('#categories_container_l2').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
            $('.select2').select2();
        }
    });
</script>
{!! Form::close() !!}