<div class="col-md-6">
    <div class="form-group">
        <label for="">Type de l'attribut</label>
        {!! Form::select('type', [
        "" => "Séléctionnez un type",
        "text" => "Text",
        "long_text" => "Long text",
        "number" => "Numérique",
        "interval" => "Min/Max",
        "boolean" => "Oui/Non",
        "select" => "Liste de choix",
        ], null, ['class' => 'form-control', 'id' => 'attribute_type', 'required' => 'required']) !!}
    </div>
</div>

<div class="col-md-6">
    <div class="form-group ">
        <label for="">Nom de l'attribut</label>
        {!! Form::text('name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' =>
        "Nom de l'attribut"]) !!}
    </div>
</div>

@php
if(isset($attribute) && $attribute->type != "") {
        $current_attribute = $attribute->type;
    }else{
        $current_attribute = "";
    }
@endphp

{{--Type: text--}}
<div id="type_text" class="type_container" @if($current_attribute !="text" ) style="display: none;" @endif>
    <div class="col-md-6">
        <div class="form-group">
            <label for="">Valeur par défaut</label>
            {!! Form::text('default_value', null, ['class' => 'form-control', 'placeholder' => "Valeur par défaut",
            'style' => 'width: 100%;', 'disabled' => ($current_attribute !="text")]) !!}
        </div>
    </div>
    <div class="clearfix"></div>
</div>
{{--End Type: text--}}

{{--Type: long_text--}}
<div id="type_long_text" class="type_container" @if($current_attribute !="long_text" ) style="display: none;" @endif>
    <div class="col-md-6">
        <div class="form-group">
            <label for="">Valeur par défaut</label>
            {!! Form::textarea('default_value', null, ['class' => 'form-control', 'placeholder' => "Valeur par défaut", 'style' => 'width: 100%;', 'rows' => '5', 'disabled' => ($current_attribute !="long_text")]) !!}
        </div>
    </div>
    <div class="clearfix"></div>
</div>
{{--End Type: long_text--}}

{{--Type: number--}}
<div id="type_number" class="type_container" @if($current_attribute !="number" ) style="display: none;" @endif>
    <div class="col-md-6">
        <div class="form-group">
            <label for="">Valeur par défaut</label>
            {!! Form::number('default_value', null, ['class' => 'form-control', 'placeholder' => "Valeur par défaut", 'style' => 'width: 100%;', 'step' => 'any', 'disabled' => ($current_attribute !="number")]) !!}
        </div>
    </div>
    <div class="clearfix"></div>
</div>
{{--End Type: number--}}

{{--Type: interval--}}
<div id="type_interval" class="type_container" @if($current_attribute !="interval" ) style="display: none;" @endif>
    <div class="col-md-6">
        <div class="form-group">
            <label for="">Valeurs Min/Max par défaut</label>
            <div class="input-group">
                <input type="number" class="form-control" name="default_value_min" placeholder="Min" style="width: 50%;"
            step="any" disabled="{{ ($current_attribute !="interval") }}">
                <input type="number" class="form-control" name="default_value_max" placeholder="Max" style="width: 50%;"
                    step="any" disabled="{{ ($current_attribute !="interval") }}">
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
</div>
{{--End Type: interval--}}

{{--Type: boolean--}}
<div id="type_boolean" class="type_container" @if($current_attribute !="boolean" ) style="display: none;" @endif>
    <div class="col-md-6">
        <div class="form-group">
            <label for="">Valeur par défaut</label>
            {!! Form::select('default_value', ['1' => 'Oui', '0' => 'Non'] ,null, ['class' => 'form-control',
            'placeholder' => "Valeur par défaut", 'style' => 'width: 100%;', 'disabled' => ($current_attribute !="boolean")]) !!}
        </div>
    </div>
    <div class="clearfix"></div>
</div>
{{--End Type: boolean--}}

{{--Type: select--}}
<div id="type_select" class="type_container" @if($current_attribute !="select" ) style="display: none;" @endif>
    <div class="col-md-6">
        <div class="form-group">
            <label for="">Valeur par défaut</label>
            {!! Form::text('default_value', null, ['class' => 'form-control', 'placeholder' => "Valeur par défaut",
            'style' => 'width: 100%;', 'disabled' => ($current_attribute !="select")]) !!}
            <label for="">Multi-valeurs</label>
            {!! Form::select('multi_value', ['1' => 'Oui', '0' => 'Non'] , (!isset($attribute)?'0':null), ['class'
            => 'form-control', 'style' => 'width: 100%;']) !!}
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="">Liste des valeurs</label>
            {!! Form::textarea('value', null, ['class' => 'form-control', 'placeholder' => "Liste des valeurs",
            'style' => 'width: 100%;', 'rows' => '5']) !!}
            <p class="help-block">Une valeur par ligne</p>
        </div>
    </div>

    <div class="clearfix"></div>
</div>
{{--End Type: select--}}

<div class="col-md-12">
    <div class="form-group">
        <div class="row">
            <div class="col-md-4">
                <label for="">Obligatoire</label>
                {!! Form::select('required', ['1' => 'Oui', '0' => 'Non'], null, ['class' => 'form-control', 'style'
                => 'width: 100%;']) !!}
            </div>
            <div class="col-md-4">
                <label for="">Afficher dans le filtre</label>
                {!! Form::select('filtrable', ['1' => 'Oui', '0' => 'Non'], null, ['class' => 'form-control',
                'style' => 'width: 100%;']) !!}

            </div>
            <div class="col-md-4">
                <label for="">Unité</label>
                {!! Form::text('unite', null, ['class' => 'form-control', 'placeholder' => "Unité", 'style' =>
                'width: 100%;']) !!}

            </div>
        </div>
    </div>
</div>
<div class="clearfix"></div>


<script>
        $(function () {
            
            // $('.type_container input, .type_container textarea, .type_container select').each(function(){
            //     $(this).attr('disabled', false);
            // });
            
            
            $('#attribute_type').on('change', function(event){
                var $selected_type = $(this).val();
                $('.type_container').hide();
                $('.type_container input, .type_container textarea, .type_container select').each(function(){
                    //this.value = "";
                    $(this).attr('disabled', true);
                });
                $('#type_' + $selected_type).show();
                $('#type_'+ $selected_type +' input, #type_'+ $selected_type +' textarea, #type_'+ $selected_type +' select').each(function(){
                    //this.value = "";
                    $(this).attr('disabled', false);
                    console.log("'disabled', false");
                });
            });
    
            
    
        })
    </script>
