@extends('layouts.auth')

@section('content')
    <div class="login-box">
        <div class="login-logo">
            <a href="{{ route('home') }}">
                <b>
                    {{ config('app.name', 'Administration') }}
                </b>
            </a>
        </div>
        <!-- /.login-logo -->
        <div class="login-box-body">
            @if (session('status'))
                <div class="alert alert-success">
                    {{ session('status') }}
                </div>
            @endif
            <p class="login-box-msg">Réinitialiser le mot de passe<br></p>
            <form class="" method="POST" action="{{ route('password.email') }}">
                {{ csrf_field() }}
                <div class="form-group has-feedback {{ $errors->has('email') ? ' has-error' : '' }}">
                    <label for="email">Adresse e-mail</label>
                    <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" required autofocus>
                    <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                </div>
                @if ($errors->has('email'))
                    <span class="help-block">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary btn-flat pull-right">
                            Envoyer le lien de réinitialisation
                        </button>
                    </div>
                </div>
            </form>
            <br>
            <a href="{{ route('login') }}">
                Se connecter
            </a>
            <br>

        </div>
        <br>
        <a href="{{ route('home') }}">
            ← Retour vers le site
        </a>
        <!-- /.login-box-body -->
    </div>
    <!-- /.login-box -->
@endsection
