
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');
require('./common');

$(function () {
    $('#categories').on('click', '.category', function (event) {
        event.preventDefault();
        $(this).parents('.panel').find('.sub-categories').toggle(400);
    });

    $('#thematiques_catalogues a').on('click', function (event) {
        event.preventDefault();
        $('#thematiques_catalogues a.active').removeClass('active');
        $(this).addClass('active');
        $('#catalogues_content').LoadingOverlay("show");
        $('#catalogues_content').load($(this).attr('href'), function (response, status, xhr) {
            $('#catalogues_content').LoadingOverlay("hide");
        });
    });

    $("#menu .input-group-btn .dropdown-menu li a").click(function () {
        var selText = $(this).html();
        var dataType = $(this).data('type');
        var dataAction = $(this).data('action');
        //working version - for single button //
        //$('.btn:first-child').html(selText+'<span class="caret"></span>');
        //working version - for multiple buttons //
        $(this).parents('.input-group-btn').find('.btn-search').html(selText);
        $('#query_type').val(dataType);
        $(this).parents('form').attr('action', dataAction);

    });

    $('.filter-field').on('click', function (event) {
        $('.filter-values:visible').not($(this).parents('.form-group').find('.filter-values')).hide();
        $(this).parents('.form-group').find('.filter-values').toggle();
    });

    $('.filter-close').on('click', function (event) {
        event.preventDefault();
        $(this).parents('.filter-values').toggle();
    });

    //$('input[type="radio"]')
    $('.filter-values-list input[type="radio"]').on('change', function (event) {
        event.preventDefault();
        $(this).parents('.filter-values').toggle();
    });

    $('.filter .has_childs input[type="radio"]').on('change', function (event) {
        event.preventDefault();
        //$(this).parents('.filter-values').toggle();
        $current_filter_id = $(this).parents('.has_childs').data('filter_id');
        $selected_value = $.trim($(this).val());
        $("div[data-filter_parent_id='" + $current_filter_id +"']").hide();
        $("div[data-filter_parent_id='" + $current_filter_id +"']").find(":input").prop("disabled", true);
        $("div[data-filter_parent_value='" + $selected_value +"']").show();
        $("div[data-filter_parent_value='" + $selected_value +"']").find(":input").prop("disabled", false);
        console.log($selected_value);
    });

    $('.select2').select2();

    $('#category_id_l0').on('change', function () {
        var $selected_cat = $(this).val();
        if ($selected_cat) {
            $('#categories_container_l1').load('/categories/' + $selected_cat + '/select', function () {
                $('.select2').select2();
            })
        } else {
            $('#categories_container_l1').html('');
            $('#categories_container_l2').html('');
        }
    });

    $('#categories_container_l1').on('change', '#category_id', function () {
        var $selected_cat = $(this).val();
        if ($selected_cat) {
            $('#categories_container_l2').load('/categories/' + $selected_cat + '/select', function () {
                $('.select2').select2();
            })
        } else {
            $('#categories_container_l2').html('');
        }
    });

    $('#categories_container_l2').on('change', '#category_id', function () {
        var $selected_url = $(this).val();
        if ($selected_url) {
            var $page_url = $(this).attr('rel');
            document.location.href = $page_url + '/' + $selected_url;
        }
    });

    var typingTimer;
    $('#menu-search-input').on('keyup', function () {
        clearTimeout(typingTimer);
        var $search_terme = $(this).val();

        if ($search_terme) {
            typingTimer = setTimeout(loadSearch, 500);
        } else {
            $('.autofill-container').html('').hide();
        }
    });
    var loadSearch = function () {
        if ($('#query_type').val() == 'products') {
            $('.autofill-container').load('/categories/autocomplete?q=' + $('#menu-search-input').val(), function () {
                $('.autofill-container').show();
            })
        }
    }


});