window.$ = window.jQuery = require('jquery');
require('./common');

tinymce.init({
    selector:'.tinymce' ,
    height: 323,
    theme: 'modern',
    menubar: false,
    branding: false,
    plugins: "lists link image",
    toolbar: 'undo redo | bold italic underline | numlist bullist link image'
});

$(function(){
    $.fn.datepicker.defaults.format = "dd/mm/yyyy";
    $('.datepicker').datepicker();

    $('.select2').select2();
    
    $('#category_id_l0').on('change', function(){
        var $selected_cat = $(this).val();
        if($selected_cat) {
            $('#categories_container_l1').load('/categories/'+$selected_cat+'/select?level=1', function() {
                $('.select2').select2();
            })
        }else{
            $('#categories_container_l1').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
            $('#categories_container_l2').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
            $('.select2').select2();
        }
    });

    $('#categories_container_l1').on('change', '#category_id_l1', function(){
        var $selected_cat = $(this).val();
        if($selected_cat) {
            $('#categories_container_l2').load('/categories/'+$selected_cat+'/select?level=2', function() {
                $('.select2').select2();
            })
        }else{
            $('#categories_container_l2').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
            $('.select2').select2();
        }
    });

    $('#categories_container_l2').on('change', '#category_id', function(){
        var $selected_cat = $(this).val();
        if($selected_cat) {
            var $page_url = $("#current_url").val();
            if($page_url)
            document.location.href = $page_url + '/' +$selected_cat;
        }
    });

    $('body').on('change', '.has_childs select', function (event) {
        event.preventDefault();
        //$(this).parents('.filter-values').toggle();
        $current_filter_id = $(this).parents('.has_childs').data('filter_id');
        $selected_value = $.trim($(this).val());
        $("div[data-filter_parent_id='" + $current_filter_id +"']").hide();
        $("div[data-filter_parent_id='" + $current_filter_id +"']").find(":input").prop("disabled", true);
        $("div[data-filter_parent_value='" + $selected_value +"']").show();
        $("div[data-filter_parent_value='" + $selected_value +"']").find(":input").prop("disabled", false);
    });
    //disable all hidden sub attributes
    $('div[data-filter_parent_id]:hidden').find(":input").prop("disabled", true);
});
