<?php

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Users table seeding start');
        $data = [
            [
                'created_at'    =>  date('Y-m-d H:i:s'),
                'name'          =>  'Admin Admin',
                'email'         =>  'admin@prosourcing.dz',
                'password'      =>  \Hash::make('123456'),
                'role_id'       => 1,
                'company_id'    => null
            ],
            [
                'created_at'    =>  date('Y-m-d H:i:s'),
                'name'          =>  'Client Client',
                'email'         =>  'client@prosourcing.dz',
                'password'      =>  \Hash::make('123456'),
                'role_id'       => 2,
                'company_id'    => 1
            ],
        ];

        DB::table('users')->delete();
        User::insert($data);

        if( App::environment() === 'development' || App::environment() === 'local' ) {
            factory(App\Models\User::class, 100)->create();
        }
        $this->command->info('Users table seeding end');
    }
}
