<?php

use App\Models\ProjectCategory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProjectCategoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Project Categories table seeding start');
        $data = [

            ['id' => 1 , 'name' => "Robotique et automatisation"],
            ['id' => 2 , 'name' => "Transports Industrie automobile/ aérospatiale"],
            ['id' => 3 , 'name' => "IT & technologies - Telecom"],
            ['id' => 4 , 'name' => "Énergie"],
            ['id' => 5 , 'name' => "Industrie (production, processus)"],
            ['id' => 6 , 'name' => "Bâtiment et construction"],
            ['id' => 7 , 'name' => "Médical"],
            ['id' => 8 , 'name' => "Industrie alimentaire"],
        ];

        DB::table('project_categories')->delete();
        ProjectCategory::insert($data);
        $categories = ProjectCategory::all();
        foreach ($categories as $category) {
            $category->slug = str_slug($category->name);
            $category->save();
        }
        $this->command->info('Project Categories table seeding end');
    }
}
