<?php

use Illuminate\Database\Seeder;

class ProductsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Products table seeding start');

        factory(App\Models\Product::class, 2000)->create();

        $products = \App\Models\Product::all();
        foreach ($products as $product) {
            $product->slug = str_slug($product->name);
            $product->save();
        }
        $this->command->info('Products table seeding end');
    }
}
