<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFields2ToCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->string('secteur')->nullable();
            $table->integer('secteur_activite')->nullable();
            $table->integer('nature_activite')->nullable();
            $table->integer('contact_fonction')->nullable()->change();
            $table->string('company_nif')->unique()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn('secteur');
            $table->dropColumn('secteur_activite');
            $table->dropColumn('nature_activite');
            $table->string('contact_fonction')->nullable()->change();
            $table->dropUnique('companies_company_nif_unique');
        });
    }
}
