<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->string('lat')->nullable();
            $table->string('long')->nullable();
            $table->string('contact_fonction')->after('nom')->nullable();
            $table->string('contact_email')->after('contact_fonction')->nullable();
            $table->string('mobile2')->after('mobile')->nullable();
            $table->integer('wilaya_id')->after('adresse')->nullable();
            $table->integer('commune_id')->after('wilaya_id')->nullable();
            $table->string('codepostal')->after('commune_id')->nullable();
            $table->string('company_size')->nullable();
            $table->string('company_forme_social')->after('name')->nullable();
            $table->string('company_rc')->nullable();
            $table->string('company_nif')->nullable();
            $table->string('company_ai')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn('lat');
            $table->dropColumn('long');
            $table->dropColumn('contact_fonction');
            $table->dropColumn('contact_email');
            $table->dropColumn('mobile2');
            $table->dropColumn('wilaya_id');
            $table->dropColumn('commune_id');
            $table->dropColumn('codepostal');
            $table->dropColumn('company_size');
            $table->dropColumn('company_forme_social');
            $table->dropColumn('company_rc');
            $table->dropColumn('company_nif');
            $table->dropColumn('company_ai');
        });
    }
}
