<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;
use App\Models\Company;



/**
 * App\Models\Salon
 *
 * @property int $id
 * @property string $name
 * @property string|null $slug
 * @property \Carbon\Carbon|null $date_start
 * @property \Carbon\Carbon|null $date_end
 * @property string|null $ville
 * @property int|null $country_id
 * @property string|null $link
 * @property int|null $company_id
 * @property string|null $image
 * @property int|null $confirmed
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read \App\Models\Company|null $company
 * @property-read \App\Models\Country|null $country
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereConfirmed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereCountryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereDateEnd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereDateStart($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereLink($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Salon whereVille($value)
 * @mixin \Eloquent
 */
class Salon extends Model
{
    use SearchableTrait;

    protected $guarded = [];

    protected $searchable = [
        'columns' => [
            'salons.name' => 10,
            'salons.ville' => 8,
            'salons.link' => 4,
            'countries.name_fr' => 8
        ], 'joins' => [
            'countries' => ['countries.id', 'salons.country_id'],
        ],
    ];

    protected $dates = ['date_start', 'date_end'];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function scopeClient($query)
    {
        return $query->where('company_id', auth()->user()->company_id);
    }

    public function companies()
    {
        return $this->belongsToMany(Company::class);
    }
}
