<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\ProjectCategory
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Project[] $projects
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ProjectCategory whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ProjectCategory whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ProjectCategory whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ProjectCategory whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\ProjectCategory whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class ProjectCategory extends Model
{
    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function projects()
    {
        return $this->hasMany(Project::class, 'project_category_id');
    }
}
