<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Inscription extends Model
{
    use SearchableTrait;

    protected $searchable = [
        'columns' => [
            'company_name' => 10,
            'company_site' => 8,
            'prenom' => 8,
            'nom' => 8,
            'email' => 5
        ]
    ];
    protected $guarded = [];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }
}
