<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

/**
 * App\Models\Company
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property string|null $description
 * @property string|null $values
 * @property string|null $image
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Catalogue[] $catalogues
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Company whereValues($value)
 * @mixin \Eloquent
 */
class Company extends Model
{
    use SearchableTrait;

    // public function newQuery()
    // {
    //     return parent::newQuery()->wherePublished(true);
    // }

    protected $searchable = [
        'columns' => [
            'name' => 10,
            'description' => 8,
            'values' => 8,
            'email' => 5
        ]
    ];
    protected $guarded = [];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function categories()
    {
        $products_cat = Product::where('company_id', $this->id)->distinct()->pluck('category_id')->all();
        $categories = Category::whereIn('id', $products_cat)->get();
        return $categories;
    }

    public function catalogues()
    {
        return $this->hasMany(Catalogue::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function categories_list()
    {
        return $this->hasMany(CompanyCategory::class, 'company_id');
    }

    public function groupe()
    {
        return $this->belongsTo(Company::class, 'groupe_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function wilaya()
    {
        return $this->belongsTo(Wilaya::class);
    }

    public function commune()
    {
        return $this->belongsTo(Commune::class);
    }

    public function secteur_activite()
    {
        return $this->belongsTo(SecteurActivite::class, 'secteur_activite_id');
    }

    public function nature_activite()
    {
        return $this->belongsTo(NatureActivite::class, 'nature_activite_id');
    }

    public function getDisplayFormeSocialAttribute()
    {
        switch ($this->company_forme_social) {
            case 'individuelle':
                return 'Entreprise individuelle';
            case 'eurl':
                return 'EURL';
            case 'sarl':
                return 'SARL';
            case 'snc':
                return 'SNC';
            case 'spa':
                return 'SPA';
        }

        return $this->company_forme_social;
    }

    public function getDisplayCompanySizeAttribute()
    {
        switch ($this->company_size) {
            case '-10':
                return 'Mois de 10 salariés';
            case '10-20':
                return 'Entre 10 et 20 salariés';
            case '20-50':
                return 'Entre 20 et 50 salariés';
            case '50-100':
                return 'Entre 50 et 100 salariés';
            case '+100':
                return 'Plus de 100 salariés';
        }

        return $this->company_size;        
    }
    
    public function scopePublished($query)
    {
        return $query->wherePublished(true);
    }

    public function salons()
    {
        return $this->belongsToMany(Salon::class);
    }

    public function products()
    {
        return $this->belongsTomany(Product::class);
    }
}
