<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

/**
 * App\Models\Catalogue
 *
 * @property int $id
 * @property string $name
 * @property string|null $slug
 * @property int|null $number_pages
 * @property string|null $filename
 * @property int|null $category_id
 * @property int|null $company_id
 * @property string|null $image
 * @property int|null $number_views
 * @property int|null $archive
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read \App\Models\Category|null $category
 * @property-read \App\Models\Company|null $company
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue search($search, $threshold = null, $entireText = false, $entireTextOnly = false)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue searchRestricted($search, $restriction, $threshold = null, $entireText = false, $entireTextOnly = false)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereArchive($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereFilename($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereNumberPages($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereNumberViews($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogue whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Catalogue extends Model
{
    protected $guarded = [];
    use SearchableTrait;

    protected $searchable = [
        'columns' => [
            'catalogues.name' => 10,
            'catalogues.filename' => 10,
            'categories.name' => 8,
        ], 'joins' => [
            'categories' => ['categories.id','catalogues.category_id'],
        ],
    ];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function scopeClient($query)
    {
        return $query->where('company_id', auth()->user()->company_id);
    }

    public function getFileLinkAttribute($value)
    {
        return asset('storage/brands/'.$this->brand_id .'/catalogues/' . $this->filename);
    }
    
    public function getImageLinkAttribute($value)
    {
        return asset('storage/brands/'.$this->brand_id .'/catalogues/' . $this->image);
    }
}
