<?php

namespace App\Http\Controllers\Client;

use App\Models\Trend;
use App\Models\TrendCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class TrendController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        if($query) {
            $trends = Trend::Client()->with('category')->search($query, null, true)->paginate(20);
        }else{
            $trends = Trend::Client()->with('category')->paginate(20);
        }
        return view('clients.trends.index', compact('trends'));
    }

    public function create()
    {
        $categories = TrendCategory::pluck('name', 'id');
        return view('clients.trends.create', compact('categories'));
    }

    public function store(Request $request)
    {
        $trend = Trend::Client()->create($request->input());
        $trend->company_id = auth()->user()->company_id;
        $trend->slug = str_slug($request->input('name'), '-');
        $trend->save();

        if( $request->hasFile('image') ) {
            $file = $request->file('image');
            $path = 'public/companies/'. $trend->company_id . '/trends/';
            $path = $request->file('image')->storeAs($path, $trend->id . '.' . $file->getClientOriginalExtension());
            $trend->image = $trend->id . '.' . $file->getClientOriginalExtension();
            $trend->save();
        }

        return redirect()->route('clients.trends.show', $trend->id );
    }

    public function show($id)
    {
        $trend = Trend::Client()->findOrFail($id);
        return view('clients.trends.show', compact('trend'));
    }

    public function edit($id)
    {
        $categories = TrendCategory::pluck('name', 'id');
        $trend = Trend::Client()->findOrFail($id);
        return view('clients.trends.edit', compact('trend', 'categories'));
    }

    public function update(Request $request, $id)
    {
        $trend = Trend::Client()->findOrFail($id);
        $trend->fill($request->input());
        $trend->save();

        if( $request->hasFile('image') ) {
            // Delete old file
            $path = 'public/companies/'. $trend->company_id . '/trends/' . $trend->image;
            if(!empty($trend->image) && File::exists(storage_path('app/' . $path))) {
                Storage::delete($path);
            }
            // Upload new file
            $file = $request->file('image');
            $path = 'public/companies/'. $trend->company_id . '/trends/';
            $path = $request->file('image')->storeAs($path, $trend->id . '.' . $file->getClientOriginalExtension());
            $trend->image = $trend->id . '.' . $file->getClientOriginalExtension();
            $trend->save();
        }

        return redirect()->route('clients.trends.show', $trend->id );
    }

    public function delete($id)
    {
        $trend = Trend::Client()->findOrFail($id);
        $trend->delete();

        return redirect()->route('clients.trends.index');
    }
}
