<?php

namespace App\Http\Controllers\Client;

use App\Models\Salon;
use App\Models\Country;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SalonController extends Controller
{
    public function index(Request $request)
    {
        $company_id = auth()->user()->company_id;
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        if($query) {
            $salons = Salon::with(['companies', 'country'])->search($query, null, true)->paginate(20);
        }else{
            $salons = Salon::with(['companies', 'country'])->paginate(20);
        }
        return view('clients.salons.index', compact('salons', 'company_id'));
    }

    public function show($id)
    {
        $salon = Salon::findOrFail($id);
        $participe = $salon->companies->contains(auth()->user()->company_id);
        return view('clients.salons.show', compact('salon', 'participe'));
    }

    public function participation($id)
    {
        $company_id = auth()->user()->company_id;
        $salon = Salon::findOrFail($id);
        $salon->companies()->attach($company_id );

        return redirect()->route('clients.salons.show', $id);
    }


    public function participationCancel($id)
    {
        $company_id = auth()->user()->company_id;
        $salon = Salon::findOrFail($id);
        $salon->companies()->detach($company_id );

        return redirect()->route('clients.salons.show', $id);
    }
   

}
