<?php

namespace App\Http\Controllers\Client;

use App\Models\ProjectCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Project;

class ProjectController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        if($query) {
            $projects = Project::Client()->with('category')->search($query, null, true)->paginate(20);
        }else{
            $projects = Project::Client()->with('category')->paginate(20);
        }
        return view('clients.projects.index', compact('projects'));
    }

    public function create()
    {
        $categories = ProjectCategory::pluck('name', 'id');
        return view('clients.projects.create', compact('categories'));
    }

    public function store(Request $request)
    {
        $project = Project::Client()->create($request->input());
        $project->company_id = auth()->user()->company_id;
        $project->slug = str_slug($request->input('name'), '-');
        $project->save();

        return redirect()->route('clients.projects.show', $project->id );
    }

    public function show($id)
    {
        $project = Project::Client()->findOrFail($id);
        return view('clients.projects.show', compact('project'));
    }

    public function edit($id)
    {
        $categories = ProjectCategory::pluck('name', 'id');
        $project = Project::Client()->findOrFail($id);
        return view('clients.projects.edit', compact('project', 'categories'));
    }

    public function update(Request $request, $id)
    {
        $project = Project::Client()->findOrFail($id);
        $project->fill($request->input());
        $project->save();

        return redirect()->route('clients.projects.show', $project->id );
    }

    public function delete($id)
    {
        $project = Project::Client()->findOrFail($id);
        $project->delete();

        return redirect()->route('clients.projects.index');
    }
}
