<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Role;

class UserController extends Controller
{
    public function index()
    {
        $users = User::where('role_id', '<>', 2)->paginate();
        $roles = Role::where('id', '<>', 2)->pluck('name', 'id');
        return view('backend.users.index', compact('users', 'roles'));
    }

    public function create()
    {
        $roles = Role::where('id', '<>', 2)->pluck('name', 'id');
        return view('backend.users.create', compact('roles'));
    }

    public function store(Request $request)
    {
        $user = new User;
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->role_id = $request->input('role_id');
        $user->password = \Hash::make($request->input('password'));
        $user->save();
        return redirect()->route('backend.users.index');
    }

    public function edit($id)
    {
        $user = User::findOrfail($id);
        $roles = Role::where('id', '<>', 2)->pluck('name', 'id');
        return view('backend.users.edit', compact('roles', 'user'));
    }

    public function update(Request $request, $id)
    {
        $user = User::findOrfail($id);
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->role_id = $request->input('role_id');
        if(!empty($request->input('password'))) {
            $user->password = \Hash::make($request->input('password'));
        }
        $user->save();
        return redirect()->route('backend.users.index');
    }
}
