<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\SecteurActivite;

class SecteurActiviteController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;

        $secteurQuery = SecteurActivite::query();

        if($query) {
            $secteurQuery = $secteurQuery->search($query, null, true);
        }
        $secteurs = $secteurQuery->paginate(20);
        return view('backend.secteurs.index', compact('secteurs'));
    }

    public function create()
    {
        return view('backend.secteurs.create');
    }

    public function store(Request $request)
    {
        $secteur = SecteurActivite::create($request->input());

        return redirect()->route('backend.secteur_activites.index');
    }

    public function edit($id)
    {
        $secteur = SecteurActivite::findOrFail($id);

        return view('backend.secteurs.edit', compact('secteur'));
    }

    public function update(Request $request, $id)
    {
        $secteur = SecteurActivite::findOrFail($id);
        $secteur->fill($request->input());
        $secteur->save();

        return redirect()->route('backend.secteur_activites.index');
    }

    public function delete($id)
    {
        $secteur = SecteurActivite::findOrFail($id);
        $secteur->delete();

        return redirect()->route('backend.secteur_activites.index');
    }
}
