<?php

namespace App\Http\Controllers\Backend;

use App\Models\Place;
use App\Models\Country;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class PlaceController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        $company = !empty($request->get('company')) ? $request->get('company') : null;
        $placesQuery = Place::with('company');
        if($query) {
            $placesQuery = $placesQuery->search($query, null, true);
        }
        if($company) {
            $placesQuery = $placesQuery->where('company_id', $company);
        }
        $places = $placesQuery->paginate(20);
        $companies = Company::pluck('name', 'id');
        return view('backend.places.index', compact('places', 'companies'));
    }

    public function create()
    {
        $countries = Country::pluck('name_fr', 'id');
        $companies = Company::pluck('name', 'id');
        return view('backend.places.create', compact('countries', 'companies'));
    }

    public function store(Request $request)
    {
        $place = Place::create($request->input());
        $place->company_id = auth()->user()->company_id;
        $place->save();

        if( $request->hasFile('image') ) {
            $file = $request->file('image');
            $path = 'public/companies/'. $place->company_id . '/places/';
            $path = $request->file('image')->storeAs($path, $place->id . '.' . $file->getClientOriginalExtension());
            $place->image = $place->id . '.' . $file->getClientOriginalExtension();
            $place->save();
        }

        return redirect()->route('backend.places.show', $place->id );
    }

    public function show($id)
    {
        $place = Place::findOrFail($id);
        return view('backend.places.show', compact('place'));
    }

    public function edit($id)
    {
        $countries = Country::pluck('name_fr', 'id');
        $companies = Company::pluck('name', 'id');
        $place = Place::findOrFail($id);
        return view('backend.places.edit', compact('place', 'countries', 'companies'));
    }

    public function update(Request $request, $id)
    {
        $place = Place::findOrFail($id);
        $place->fill($request->input());
        $place->save();

        if( $request->hasFile('image') ) {
            // Delete old file
            $path = 'public/companies/'. $place->company_id . '/places/' . $place->image;
            if(!empty($place->image) && File::exists(storage_path('app/' . $path))) {
                Storage::delete($path);
            }
            // Upload new file
            $file = $request->file('image');
            $path = 'public/companies/'. $place->company_id . '/places/';
            $path = $request->file('image')->storeAs($path, $place->id . '.' . $file->getClientOriginalExtension());
            $place->image = $place->id . '.' . $file->getClientOriginalExtension();
            $place->save();
        }

        return redirect()->route('backend.places.show', $place->id );
    }

    public function delete($id)
    {
        $place = Place::findOrFail($id);
        $place->delete();

        return redirect()->route('backend.places.index');
    }
}
