<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\NatureActivite;

class NatureActiviteController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;

        $natureQuery = NatureActivite::query();

        if($query) {
            $natureQuery = $natureQuery->search($query, null, true);
        }
        $natures = $natureQuery->paginate(20);
        return view('backend.natures.index', compact('natures'));
    }

    public function create()
    {
        return view('backend.natures.create');
    }

    public function store(Request $request)
    {
        $nature = NatureActivite::create($request->input());

        return redirect()->route('backend.nature_activites.index');
    }

    public function edit($id)
    {
        $nature = NatureActivite::findOrFail($id);

        return view('backend.natures.edit', compact('nature'));
    }

    public function update(Request $request, $id)
    {
        $nature = NatureActivite::findOrFail($id);
        $nature->fill($request->input());
        $nature->save();

        return redirect()->route('backend.nature_activites.index');
    }

    public function delete($id)
    {
        $nature = NatureActivite::findOrFail($id);
        $nature->delete();

        return redirect()->route('backend.nature_activites.index');
    }
}
